# Generated by default/object.tt
package Paws::GreengrassV2::EffectiveDeployment;
  use Moose;
  has CoreDeviceExecutionStatus => (is => 'ro', isa => 'Str', request_name => 'coreDeviceExecutionStatus', traits => ['NameInRequest'], required => 1);
  has CreationTimestamp => (is => 'ro', isa => 'Str', request_name => 'creationTimestamp', traits => ['NameInRequest'], required => 1);
  has DeploymentId => (is => 'ro', isa => 'Str', request_name => 'deploymentId', traits => ['NameInRequest'], required => 1);
  has DeploymentName => (is => 'ro', isa => 'Str', request_name => 'deploymentName', traits => ['NameInRequest'], required => 1);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has IotJobArn => (is => 'ro', isa => 'Str', request_name => 'iotJobArn', traits => ['NameInRequest']);
  has IotJobId => (is => 'ro', isa => 'Str', request_name => 'iotJobId', traits => ['NameInRequest']);
  has ModifiedTimestamp => (is => 'ro', isa => 'Str', request_name => 'modifiedTimestamp', traits => ['NameInRequest'], required => 1);
  has Reason => (is => 'ro', isa => 'Str', request_name => 'reason', traits => ['NameInRequest']);
  has TargetArn => (is => 'ro', isa => 'Str', request_name => 'targetArn', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::EffectiveDeployment

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::EffectiveDeployment object:

  $service_obj->Method(Att1 => { CoreDeviceExecutionStatus => $value, ..., TargetArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::EffectiveDeployment object:

  $result = $service_obj->Method(...);
  $result->Att1->CoreDeviceExecutionStatus

=head1 DESCRIPTION

Contains information about a deployment job that AWS IoT Greengrass
sends to a AWS IoT Greengrass core device.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CoreDeviceExecutionStatus => Str

The status of the deployment job on the AWS IoT Greengrass core device.


=head2 B<REQUIRED> CreationTimestamp => Str

The time at which the deployment was created, expressed in ISO 8601
format.


=head2 B<REQUIRED> DeploymentId => Str

The ID of the deployment.


=head2 B<REQUIRED> DeploymentName => Str

The name of the deployment.

You can create deployments without names. If you create a deployment
without a name, the AWS IoT Greengrass V2 console shows the deployment
name as C<E<lt>targetTypeE<gt>:E<lt>targetNameE<gt>>, where
C<targetType> and C<targetName> are the type and name of the deployment
target.


=head2 Description => Str

The description of the deployment job.


=head2 IotJobArn => Str

The ARN
(https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
of the AWS IoT job that applies the deployment to target devices.


=head2 IotJobId => Str

The ID of the AWS IoT job that applies the deployment to target
devices.


=head2 B<REQUIRED> ModifiedTimestamp => Str

The time at which the deployment job was last modified, expressed in
ISO 8601 format.


=head2 Reason => Str

The reason code for the update, if the job was updated.


=head2 B<REQUIRED> TargetArn => Str

The ARN
(https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
of the target AWS IoT thing or thing group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

