# Generated by default/object.tt
package Paws::IoT::DetectMitigationActionExecution;
  use Moose;
  has ActionName => (is => 'ro', isa => 'Str', request_name => 'actionName', traits => ['NameInRequest']);
  has ErrorCode => (is => 'ro', isa => 'Str', request_name => 'errorCode', traits => ['NameInRequest']);
  has ExecutionEndDate => (is => 'ro', isa => 'Str', request_name => 'executionEndDate', traits => ['NameInRequest']);
  has ExecutionStartDate => (is => 'ro', isa => 'Str', request_name => 'executionStartDate', traits => ['NameInRequest']);
  has Message => (is => 'ro', isa => 'Str', request_name => 'message', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has TaskId => (is => 'ro', isa => 'Str', request_name => 'taskId', traits => ['NameInRequest']);
  has ThingName => (is => 'ro', isa => 'Str', request_name => 'thingName', traits => ['NameInRequest']);
  has ViolationId => (is => 'ro', isa => 'Str', request_name => 'violationId', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::DetectMitigationActionExecution

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoT::DetectMitigationActionExecution object:

  $service_obj->Method(Att1 => { ActionName => $value, ..., ViolationId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoT::DetectMitigationActionExecution object:

  $result = $service_obj->Method(...);
  $result->Att1->ActionName

=head1 DESCRIPTION

Describes which mitigation actions should be executed.

=head1 ATTRIBUTES


=head2 ActionName => Str

The friendly name that uniquely identifies the mitigation action.


=head2 ErrorCode => Str

The error code of a mitigation action.


=head2 ExecutionEndDate => Str

The date a mitigation action ended.


=head2 ExecutionStartDate => Str

The date a mitigation action was started.


=head2 Message => Str

The message of a mitigation action.


=head2 Status => Str

The status of a mitigation action.


=head2 TaskId => Str

The unique identifier of the task.


=head2 ThingName => Str

The name of the thing.


=head2 ViolationId => Str

The unique identifier of the violation.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

