# Generated by default/object.tt
package Paws::IoTAnalytics::DeltaTimeSessionWindowConfiguration;
  use Moose;
  has TimeoutInMinutes => (is => 'ro', isa => 'Int', request_name => 'timeoutInMinutes', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTAnalytics::DeltaTimeSessionWindowConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTAnalytics::DeltaTimeSessionWindowConfiguration object:

  $service_obj->Method(Att1 => { TimeoutInMinutes => $value, ..., TimeoutInMinutes => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTAnalytics::DeltaTimeSessionWindowConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->TimeoutInMinutes

=head1 DESCRIPTION

A structure that contains the configuration information of a delta time
session window.

C<DeltaTime>
(https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html)
specifies a time interval. You can use C<DeltaTime> to create dataset
contents with data that has arrived in the data store since the last
execution. For an example of C<DeltaTime>, see Creating a SQL dataset
with a delta window (CLI)
(https://docs.aws.amazon.com/iotanalytics/latest/userguide/automate-create-dataset.html#automate-example6)
in the I<AWS IoT Analytics User Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> TimeoutInMinutes => Int

A time interval. You can use C<timeoutInMinutes> so that AWS IoT
Analytics can batch up late data notifications that have been generated
since the last execution. AWS IoT Analytics sends one batch of
notifications to Amazon CloudWatch Events at one time.

For more information about how to write a timestamp expression, see
Date and Time Functions and Operators
(https://prestodb.io/docs/0.172/functions/datetime.html), in the
I<Presto 0.172 Documentation>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTAnalytics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

