# Generated by default/object.tt
package Paws::LexRuntimeV2::Intent;
  use Moose;
  has ConfirmationState => (is => 'ro', isa => 'Str', request_name => 'confirmationState', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has Slots => (is => 'ro', isa => 'Paws::LexRuntimeV2::Slots', request_name => 'slots', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntimeV2::Intent

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntimeV2::Intent object:

  $service_obj->Method(Att1 => { ConfirmationState => $value, ..., State => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntimeV2::Intent object:

  $result = $service_obj->Method(...);
  $result->Att1->ConfirmationState

=head1 DESCRIPTION

The current intent that Amazon Lex V2 is attempting to fulfill.

=head1 ATTRIBUTES


=head2 ConfirmationState => Str

Contains information about whether fulfillment of the intent has been
confirmed.


=head2 B<REQUIRED> Name => Str

The name of the intent.


=head2 Slots => L<Paws::LexRuntimeV2::Slots>

A map of all of the slots for the intent. The name of the slot maps to
the value of the slot. If a slot has not been filled, the value is
null.


=head2 State => Str

Contains fulfillment information for the intent.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntimeV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

