# Generated by default/object.tt
package Paws::Macie2::LastRunErrorStatus;
  use Moose;
  has Code => (is => 'ro', isa => 'Str', request_name => 'code', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::LastRunErrorStatus

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::LastRunErrorStatus object:

  $service_obj->Method(Att1 => { Code => $value, ..., Code => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::LastRunErrorStatus object:

  $result = $service_obj->Method(...);
  $result->Att1->Code

=head1 DESCRIPTION

Specifies whether any account- or bucket-level access errors occurred
when a classification job ran. For information about using logging data
to investigate these errors, see Monitoring sensitive data discovery
jobs
(https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-monitor-cw-logs.html)
in the I<Amazon Macie User Guide>.

=head1 ATTRIBUTES


=head2 Code => Str

Specifies whether any account- or bucket-level access errors occurred
when the job ran. For a recurring job, this value indicates the error
status of the job's most recent run. Possible values are:

=over

=item *

ERROR - One or more errors occurred. Amazon Macie didn't process all
the data specified for the job.

=item *

NONE - No errors occurred. Macie processed all the data specified for
the job.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

