# Generated by default/object.tt
package Paws::Macie2::MatchingBucket;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str', request_name => 'accountId', traits => ['NameInRequest']);
  has BucketName => (is => 'ro', isa => 'Str', request_name => 'bucketName', traits => ['NameInRequest']);
  has ClassifiableObjectCount => (is => 'ro', isa => 'Int', request_name => 'classifiableObjectCount', traits => ['NameInRequest']);
  has ClassifiableSizeInBytes => (is => 'ro', isa => 'Int', request_name => 'classifiableSizeInBytes', traits => ['NameInRequest']);
  has JobDetails => (is => 'ro', isa => 'Paws::Macie2::JobDetails', request_name => 'jobDetails', traits => ['NameInRequest']);
  has ObjectCount => (is => 'ro', isa => 'Int', request_name => 'objectCount', traits => ['NameInRequest']);
  has ObjectCountByEncryptionType => (is => 'ro', isa => 'Paws::Macie2::ObjectCountByEncryptionType', request_name => 'objectCountByEncryptionType', traits => ['NameInRequest']);
  has SizeInBytes => (is => 'ro', isa => 'Int', request_name => 'sizeInBytes', traits => ['NameInRequest']);
  has SizeInBytesCompressed => (is => 'ro', isa => 'Int', request_name => 'sizeInBytesCompressed', traits => ['NameInRequest']);
  has UnclassifiableObjectCount => (is => 'ro', isa => 'Paws::Macie2::ObjectLevelStatistics', request_name => 'unclassifiableObjectCount', traits => ['NameInRequest']);
  has UnclassifiableObjectSizeInBytes => (is => 'ro', isa => 'Paws::Macie2::ObjectLevelStatistics', request_name => 'unclassifiableObjectSizeInBytes', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::MatchingBucket

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::MatchingBucket object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., UnclassifiableObjectSizeInBytes => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::MatchingBucket object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

Provides statistical data and other information about an S3 bucket that
Amazon Macie monitors and analyzes.

=head1 ATTRIBUTES


=head2 AccountId => Str

The unique identifier for the Amazon Web Services account that owns the
bucket.


=head2 BucketName => Str

The name of the bucket.


=head2 ClassifiableObjectCount => Int

The total number of objects that Amazon Macie can analyze in the
bucket. These objects use a supported storage class and have a file
name extension for a supported file or storage format.


=head2 ClassifiableSizeInBytes => Int

The total storage size, in bytes, of the objects that Amazon Macie can
analyze in the bucket. These objects use a supported storage class and
have a file name extension for a supported file or storage format.

If versioning is enabled for the bucket, Macie calculates this value
based on the size of the latest version of each applicable object in
the bucket. This value doesn't reflect the storage size of all versions
of each applicable object in the bucket.


=head2 JobDetails => L<Paws::Macie2::JobDetails>

Specifies whether any one-time or recurring classification jobs are
configured to analyze objects in the bucket, and, if so, the details of
the job that ran most recently.


=head2 ObjectCount => Int

The total number of objects in the bucket.


=head2 ObjectCountByEncryptionType => L<Paws::Macie2::ObjectCountByEncryptionType>

The total number of objects that are in the bucket, grouped by
server-side encryption type. This includes a grouping that reports the
total number of objects that aren't encrypted or use client-side
encryption.


=head2 SizeInBytes => Int

The total storage size, in bytes, of the bucket.

If versioning is enabled for the bucket, Amazon Macie calculates this
value based on the size of the latest version of each object in the
bucket. This value doesn't reflect the storage size of all versions of
each object in the bucket.


=head2 SizeInBytesCompressed => Int

The total storage size, in bytes, of the objects that are compressed
(.gz, .gzip, .zip) files in the bucket.

If versioning is enabled for the bucket, Macie calculates this value
based on the size of the latest version of each applicable object in
the bucket. This value doesn't reflect the storage size of all versions
of each applicable object in the bucket.


=head2 UnclassifiableObjectCount => L<Paws::Macie2::ObjectLevelStatistics>

The total number of objects that Amazon Macie can't analyze in the
bucket. These objects don't use a supported storage class or don't have
a file name extension for a supported file or storage format.


=head2 UnclassifiableObjectSizeInBytes => L<Paws::Macie2::ObjectLevelStatistics>

The total storage size, in bytes, of the objects that Amazon Macie
can't analyze in the bucket. These objects don't use a supported
storage class or don't have a file name extension for a supported file
or storage format.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

