# Generated by default/object.tt
package Paws::NetworkFirewall::FirewallPolicyResponse;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has FirewallPolicyArn => (is => 'ro', isa => 'Str', required => 1);
  has FirewallPolicyId => (is => 'ro', isa => 'Str', required => 1);
  has FirewallPolicyName => (is => 'ro', isa => 'Str', required => 1);
  has FirewallPolicyStatus => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::Tag]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::FirewallPolicyResponse

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::FirewallPolicyResponse object:

  $service_obj->Method(Att1 => { Description => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::FirewallPolicyResponse object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

The high-level properties of a firewall policy. This, along with the
FirewallPolicy, define the policy. You can retrieve all objects for a
firewall policy by calling DescribeFirewallPolicy.

=head1 ATTRIBUTES


=head2 Description => Str

A description of the firewall policy.


=head2 B<REQUIRED> FirewallPolicyArn => Str

The Amazon Resource Name (ARN) of the firewall policy.

If this response is for a create request that had C<DryRun> set to
C<TRUE>, then this ARN is a placeholder that isn't attached to a valid
resource.


=head2 B<REQUIRED> FirewallPolicyId => Str

The unique identifier for the firewall policy.


=head2 B<REQUIRED> FirewallPolicyName => Str

The descriptive name of the firewall policy. You can't change the name
of a firewall policy after you create it.


=head2 FirewallPolicyStatus => Str

The current status of the firewall policy. You can retrieve this for a
firewall policy by calling DescribeFirewallPolicy and providing the
firewall policy's name or ARN.


=head2 Tags => ArrayRef[L<Paws::NetworkFirewall::Tag>]

The key:value pairs to associate with the resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

