# Generated by default/object.tt
package Paws::SSMContacts::Page;
  use Moose;
  has ContactArn => (is => 'ro', isa => 'Str', required => 1);
  has DeliveryTime => (is => 'ro', isa => 'Str');
  has EngagementArn => (is => 'ro', isa => 'Str', required => 1);
  has IncidentId => (is => 'ro', isa => 'Str');
  has PageArn => (is => 'ro', isa => 'Str', required => 1);
  has ReadTime => (is => 'ro', isa => 'Str');
  has Sender => (is => 'ro', isa => 'Str', required => 1);
  has SentTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMContacts::Page

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMContacts::Page object:

  $service_obj->Method(Att1 => { ContactArn => $value, ..., SentTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMContacts::Page object:

  $result = $service_obj->Method(...);
  $result->Att1->ContactArn

=head1 DESCRIPTION

Incident Manager engaging a contact's contact channel.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ContactArn => Str

The ARN of the contact that Incident Manager is engaging.


=head2 DeliveryTime => Str

The time the message was delivered to the contact channel.


=head2 B<REQUIRED> EngagementArn => Str

The ARN of the engagement that this page is part of.


=head2 IncidentId => Str

The ARN of the incident that's engaging the contact channel.


=head2 B<REQUIRED> PageArn => Str

The Amazon Resource Name (ARN) of the page to the contact channel.


=head2 ReadTime => Str

The time that the contact channel acknowledged engagement.


=head2 B<REQUIRED> Sender => Str

The user that started the engagement.


=head2 SentTime => Str

The time that Incident Manager engaged the contact channel.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMContacts>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

