# Generated by default/object.tt
package Paws::SageMaker::ContextSource;
  use Moose;
  has SourceId => (is => 'ro', isa => 'Str');
  has SourceType => (is => 'ro', isa => 'Str');
  has SourceUri => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ContextSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ContextSource object:

  $service_obj->Method(Att1 => { SourceId => $value, ..., SourceUri => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ContextSource object:

  $result = $service_obj->Method(...);
  $result->Att1->SourceId

=head1 DESCRIPTION

A structure describing the source of a context.

=head1 ATTRIBUTES


=head2 SourceId => Str

The ID of the source.


=head2 SourceType => Str

The type of the source.


=head2 B<REQUIRED> SourceUri => Str

The URI of the source.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

