# Generated by default/object.tt
package Paws::SecurityHub::AwsDynamoDbTableRestoreSummary;
  use Moose;
  has RestoreDateTime => (is => 'ro', isa => 'Str');
  has RestoreInProgress => (is => 'ro', isa => 'Bool');
  has SourceBackupArn => (is => 'ro', isa => 'Str');
  has SourceTableArn => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsDynamoDbTableRestoreSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsDynamoDbTableRestoreSummary object:

  $service_obj->Method(Att1 => { RestoreDateTime => $value, ..., SourceTableArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsDynamoDbTableRestoreSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->RestoreDateTime

=head1 DESCRIPTION

Information about the restore for the table.

=head1 ATTRIBUTES


=head2 RestoreDateTime => Str

Indicates the point in time that the table was restored to.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 RestoreInProgress => Bool

Whether a restore is currently in progress.


=head2 SourceBackupArn => Str

The ARN of the source backup from which the table was restored.


=head2 SourceTableArn => Str

The ARN of the source table for the backup.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

