# Generated by default/object.tt
package Paws::Signer::SigningPlatformOverrides;
  use Moose;
  has SigningConfiguration => (is => 'ro', isa => 'Paws::Signer::SigningConfigurationOverrides', request_name => 'signingConfiguration', traits => ['NameInRequest']);
  has SigningImageFormat => (is => 'ro', isa => 'Str', request_name => 'signingImageFormat', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Signer::SigningPlatformOverrides

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Signer::SigningPlatformOverrides object:

  $service_obj->Method(Att1 => { SigningConfiguration => $value, ..., SigningImageFormat => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Signer::SigningPlatformOverrides object:

  $result = $service_obj->Method(...);
  $result->Att1->SigningConfiguration

=head1 DESCRIPTION

Any overrides that are applied to the signing configuration of a code
signing platform.

=head1 ATTRIBUTES


=head2 SigningConfiguration => L<Paws::Signer::SigningConfigurationOverrides>

A signing configuration that overrides the default encryption or hash
algorithm of a signing job.


=head2 SigningImageFormat => Str

A signed image is a JSON object. When overriding the default signing
platform configuration, a customer can select either of two signing
formats, C<JSONEmbedded> or C<JSONDetached>. (A third format value,
C<JSON>, is reserved for future use.) With C<JSONEmbedded>, the signing
image has the payload embedded in it. With C<JSONDetached>, the payload
is not be embedded in the signing image.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Signer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

