# Generated by default/object.tt
package Paws::StorageGateway::FileSystemAssociationInfo;
  use Moose;
  has AuditDestinationARN => (is => 'ro', isa => 'Str');
  has CacheAttributes => (is => 'ro', isa => 'Paws::StorageGateway::CacheAttributes');
  has FileSystemAssociationARN => (is => 'ro', isa => 'Str');
  has FileSystemAssociationStatus => (is => 'ro', isa => 'Str');
  has GatewayARN => (is => 'ro', isa => 'Str');
  has LocationARN => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::StorageGateway::Tag]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::StorageGateway::FileSystemAssociationInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::StorageGateway::FileSystemAssociationInfo object:

  $service_obj->Method(Att1 => { AuditDestinationARN => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::StorageGateway::FileSystemAssociationInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->AuditDestinationARN

=head1 DESCRIPTION

Describes the object returned by C<DescribeFileSystemAssociations> that
describes a created file system association.

=head1 ATTRIBUTES


=head2 AuditDestinationARN => Str

The Amazon Resource Name (ARN) of the storage used for the audit logs.


=head2 CacheAttributes => L<Paws::StorageGateway::CacheAttributes>




=head2 FileSystemAssociationARN => Str

The Amazon Resource Name (ARN) of the file system association.


=head2 FileSystemAssociationStatus => Str

The status of the file system association. Valid Values: C<AVAILABLE> |
C<CREATING> | C<DELETING> | C<FORCE_DELETING> | C<MISCONFIGURED> |
C<UPDATING> | C<UNAVAILABLE>


=head2 GatewayARN => Str




=head2 LocationARN => Str

The ARN of the backend Amazon FSx file system used for storing file
data. For information, see FileSystem
(https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html)
in the I<Amazon FSx API Reference>.


=head2 Tags => ArrayRef[L<Paws::StorageGateway::Tag>]

A list of up to 50 tags assigned to the SMB file share, sorted
alphabetically by key name. Each tag is a key-value pair.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::StorageGateway>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

