# Generated by default/object.tt
package Paws::WAFV2::IPSet;
  use Moose;
  has Addresses => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has ARN => (is => 'ro', isa => 'Str', required => 1);
  has Description => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has IPAddressVersion => (is => 'ro', isa => 'Str', required => 1);
  has Name => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::IPSet

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::IPSet object:

  $service_obj->Method(Att1 => { Addresses => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::IPSet object:

  $result = $service_obj->Method(...);
  $result->Att1->Addresses

=head1 DESCRIPTION

Contains one or more IP addresses or blocks of IP addresses specified
in Classless Inter-Domain Routing (CIDR) notation. WAF supports all
IPv4 and IPv6 CIDR ranges except for /0. For information about CIDR
notation, see the Wikipedia entry Classless Inter-Domain Routing
(https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).

WAF assigns an ARN to each C<IPSet> that you create. To use an IP set
in a rule, you provide the ARN to the Rule statement
IPSetReferenceStatement.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Addresses => ArrayRef[Str|Undef]

Contains an array of strings that specify one or more IP addresses or
blocks of IP addresses in Classless Inter-Domain Routing (CIDR)
notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0.

Examples:

=over

=item *

To configure WAF to allow, block, or count requests that originated
from the IP address 192.0.2.44, specify C<192.0.2.44/32>.

=item *

To configure WAF to allow, block, or count requests that originated
from IP addresses from 192.0.2.0 to 192.0.2.255, specify
C<192.0.2.0/24>.

=item *

To configure WAF to allow, block, or count requests that originated
from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify
C<1111:0000:0000:0000:0000:0000:0000:0111/128>.

=item *

To configure WAF to allow, block, or count requests that originated
from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to
1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
C<1111:0000:0000:0000:0000:0000:0000:0000/64>.

=back

For more information about CIDR notation, see the Wikipedia entry
Classless Inter-Domain Routing
(https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).


=head2 B<REQUIRED> ARN => Str

The Amazon Resource Name (ARN) of the entity.


=head2 Description => Str

A description of the IP set that helps with identification.


=head2 B<REQUIRED> Id => Str

A unique identifier for the set. This ID is returned in the responses
to create and list commands. You provide it to operations like update
and delete.


=head2 B<REQUIRED> IPAddressVersion => Str

Specify IPV4 or IPV6.


=head2 B<REQUIRED> Name => Str

The name of the IP set. You cannot change the name of an C<IPSet> after
you create it.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

