/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LogPrior;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.optimization.AbstractCachingDiffFunction;
import java.util.Arrays;

public class BiasedLogConditionalObjectiveFunction
extends AbstractCachingDiffFunction {
    protected LogPrior prior;
    protected int numFeatures = 0;
    protected int numClasses = 0;
    protected int[][] data = null;
    protected int[] labels = null;
    private double[][] confusionMatrix;

    public void setPrior(LogPrior prior) {
        this.prior = prior;
    }

    @Override
    public int domainDimension() {
        return this.numFeatures * this.numClasses;
    }

    int classOf(int index) {
        return index % this.numClasses;
    }

    int featureOf(int index) {
        return index / this.numClasses;
    }

    protected int indexOf(int f, int c) {
        return f * this.numClasses + c;
    }

    public double[][] to2D(double[] x) {
        double[][] x2 = new double[this.numFeatures][this.numClasses];
        for (int i = 0; i < this.numFeatures; ++i) {
            for (int j = 0; j < this.numClasses; ++j) {
                x2[i][j] = x[this.indexOf(i, j)];
            }
        }
        return x2;
    }

    @Override
    protected void calculate(double[] x) {
        if (this.derivative == null) {
            this.derivative = new double[x.length];
        } else {
            Arrays.fill(this.derivative, 0.0);
        }
        this.value = 0.0;
        double[] sums = new double[this.numClasses];
        double[] probs = new double[this.numClasses];
        double[] weightedProbs = new double[this.numClasses];
        for (int d = 0; d < this.data.length; ++d) {
            int[] features = this.data[d];
            int observedLabel = this.labels[d];
            Arrays.fill(sums, 0.0);
            for (int c = 0; c < this.numClasses; ++c) {
                for (int f = 0; f < features.length; ++f) {
                    int i = this.indexOf(features[f], c);
                    int n = c;
                    sums[n] = sums[n] + x[i];
                }
            }
            double total = ArrayMath.logSum(sums);
            double[] weightedSums = new double[this.numClasses];
            for (int trueLabel = 0; trueLabel < this.numClasses; ++trueLabel) {
                weightedSums[trueLabel] = Math.log(this.confusionMatrix[observedLabel][trueLabel]) + sums[trueLabel];
            }
            double weightedTotal = ArrayMath.logSum(weightedSums);
            for (int c = 0; c < this.numClasses; ++c) {
                probs[c] = Math.exp(sums[c] - total);
                weightedProbs[c] = Math.exp(weightedSums[c] - weightedTotal);
                for (int f = 0; f < features.length; ++f) {
                    int i;
                    int n = i = this.indexOf(features[f], c);
                    this.derivative[n] = this.derivative[n] + (probs[c] - weightedProbs[c]);
                }
            }
            double tmpValue = 0.0;
            for (int c = 0; c < this.numClasses; ++c) {
                tmpValue += this.confusionMatrix[observedLabel][c] * Math.exp(sums[c] - total);
            }
            this.value -= Math.log(tmpValue);
        }
        this.value += this.prior.compute(x, this.derivative);
    }

    public BiasedLogConditionalObjectiveFunction(GeneralDataset<?, ?> dataset, double[][] confusionMatrix) {
        this(dataset, confusionMatrix, new LogPrior(LogPrior.LogPriorType.QUADRATIC));
    }

    public BiasedLogConditionalObjectiveFunction(GeneralDataset<?, ?> dataset, double[][] confusionMatrix, LogPrior prior) {
        this(dataset.numFeatures(), dataset.numClasses(), dataset.getDataArray(), dataset.getLabelsArray(), confusionMatrix, prior);
    }

    public BiasedLogConditionalObjectiveFunction(int numFeatures, int numClasses, int[][] data, int[] labels, double[][] confusionMatrix) {
        this(numFeatures, numClasses, data, labels, confusionMatrix, new LogPrior(LogPrior.LogPriorType.QUADRATIC));
    }

    public BiasedLogConditionalObjectiveFunction(int numFeatures, int numClasses, int[][] data, int[] labels, double[][] confusionMatrix, LogPrior prior) {
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        this.data = data;
        this.labels = labels;
        this.prior = prior;
        this.confusionMatrix = confusionMatrix;
    }
}

