/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.Entity;
import edu.stanford.nlp.ie.EntityCachingAbstractSequencePrior;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AcquisitionsPrior<IN extends CoreMap>
extends EntityCachingAbstractSequencePrior<IN> {
    double penalty = 4.0;
    double penalty1 = 3.0;
    double penalty2 = 4.0;

    public AcquisitionsPrior(String backgroundSymbol, Index<String> classIndex, List<IN> doc) {
        super(backgroundSymbol, classIndex, doc);
    }

    @Override
    public double scoreOf(int[] sequence) {
        String s1;
        String s;
        HashSet<String> purchasers = new HashSet<String>();
        HashSet<String> purchabrs = new HashSet<String>();
        HashSet<String> sellers = new HashSet<String>();
        HashSet<String> sellerabrs = new HashSet<String>();
        HashSet<String> acquireds = new HashSet<String>();
        HashSet<String> acqabrs = new HashSet<String>();
        ArrayList<Entity> purchasersL = new ArrayList<Entity>();
        ArrayList<Entity> purchabrsL = new ArrayList<Entity>();
        ArrayList<Entity> sellersL = new ArrayList<Entity>();
        ArrayList<Entity> sellerabrsL = new ArrayList<Entity>();
        ArrayList<Entity> acquiredsL = new ArrayList<Entity>();
        ArrayList<Entity> acqabrsL = new ArrayList<Entity>();
        double p = 0.0;
        for (int i = 0; i < this.entities.length; ++i) {
            Entity entity = this.entities[i];
            if (i != 0 && this.entities[i - 1] == entity || entity == null) continue;
            String type = (String)this.classIndex.get(entity.type);
            String phrase = StringUtils.join(entity.words, " ").toLowerCase();
            if (type.equals("purchaser")) {
                purchasers.add(phrase);
                purchasersL.add(entity);
                continue;
            }
            if (type.equals("purchabr")) {
                purchabrs.add(phrase);
                purchabrsL.add(entity);
                continue;
            }
            if (type.equals("seller")) {
                sellers.add(phrase);
                sellersL.add(entity);
                continue;
            }
            if (type.equals("sellerabr")) {
                sellerabrs.add(phrase);
                sellerabrsL.add(entity);
                continue;
            }
            if (type.equals("acquired")) {
                acquireds.add(phrase);
                acquiredsL.add(entity);
                continue;
            }
            if (type.equals("acqabr")) {
                acqabrs.add(phrase);
                acqabrsL.add(entity);
                continue;
            }
            System.err.println("unknown entity type: " + type);
            System.exit(0);
        }
        for (Entity purchaser : purchasersL) {
            if (purchasers.size() > 1) {
                p -= (double)purchaser.words.size() * this.penalty;
            }
            s = StringUtils.join(purchaser.words, "").toLowerCase();
            boolean match = false;
            for (Entity purchabr : purchabrsL) {
                s1 = StringUtils.join(purchabr.words, "").toLowerCase();
                if (s.indexOf(s1) < 0) continue;
                match = true;
                break;
            }
            if (match || purchabrs.size() <= 0) continue;
            p -= (double)purchaser.words.size() * this.penalty;
        }
        for (Entity seller : sellersL) {
            if (sellers.size() > 1) {
                p -= (double)seller.words.size() * this.penalty;
            }
            s = StringUtils.join(seller.words, "").toLowerCase();
            boolean match = false;
            for (Entity sellerabr : sellerabrsL) {
                s1 = StringUtils.join(sellerabr.words, "").toLowerCase();
                if (s.indexOf(s1) < 0) continue;
                match = true;
                break;
            }
            if (match || sellerabrs.size() <= 0) continue;
            p -= (double)seller.words.size() * this.penalty;
        }
        for (Entity acquired : acquiredsL) {
            if (acquireds.size() > 1) {
                p -= (double)acquired.words.size() * this.penalty;
            }
            s = StringUtils.join(acquired.words, "").toLowerCase();
            boolean match = false;
            for (Entity acqabr : acqabrsL) {
                s1 = StringUtils.join(acqabr.words, "").toLowerCase();
                if (s.indexOf(s1) < 0) continue;
                match = true;
                break;
            }
            if (match || acqabrs.size() <= 0) continue;
            p -= (double)acquired.words.size() * this.penalty;
        }
        for (Entity purchabr : purchabrsL) {
            s = StringUtils.join(purchabr.words, "").toLowerCase();
            boolean match = false;
            for (Entity purchaser : purchasersL) {
                s1 = StringUtils.join(purchaser.words, "").toLowerCase();
                if (s1.indexOf(s) < 0) continue;
                match = true;
                break;
            }
            if (!match) {
                p -= (double)purchabr.words.size() * this.penalty2;
            }
            match = false;
            for (Entity acquired : acquiredsL) {
                s1 = StringUtils.join(acquired.words, "").toLowerCase();
                if (s1.indexOf(s) < 0) continue;
                match = true;
                break;
            }
            for (Entity seller : sellersL) {
                s1 = StringUtils.join(seller.words, "").toLowerCase();
                if (s1.indexOf(s) < 0) continue;
                match = true;
                break;
            }
            if (!match) continue;
            p -= (double)purchabr.words.size() * this.penalty1;
        }
        for (Entity sellerabr : sellerabrsL) {
            s = StringUtils.join(sellerabr.words, "").toLowerCase();
            boolean match = false;
            for (Entity seller : sellersL) {
                s1 = StringUtils.join(seller.words, "").toLowerCase();
                if (s1.indexOf(s) < 0) continue;
                match = true;
                break;
            }
            if (!match) {
                p -= (double)sellerabr.words.size() * this.penalty2;
            }
            match = false;
            for (Entity acquired : acquiredsL) {
                s1 = StringUtils.join(acquired.words, "").toLowerCase();
                if (s1.indexOf(s) < 0) continue;
                match = true;
                break;
            }
            for (Entity purchaser : purchasersL) {
                s1 = StringUtils.join(purchaser.words, "").toLowerCase();
                if (s1.indexOf(s) < 0) continue;
                match = true;
                break;
            }
            if (!match) continue;
            p -= (double)sellerabr.words.size() * this.penalty1;
        }
        for (Entity acqabr : acqabrsL) {
            s = StringUtils.join(acqabr.words, "").toLowerCase();
            boolean match = false;
            for (Entity acquired : acquiredsL) {
                s1 = StringUtils.join(acquired.words, "").toLowerCase();
                if (s1.indexOf(s) < 0) continue;
                match = true;
                break;
            }
            if (!match) {
                p -= (double)acqabr.words.size() * this.penalty2;
            }
            match = false;
            for (Entity seller : sellersL) {
                s1 = StringUtils.join(seller.words, "").toLowerCase();
                if (s1.indexOf(s) < 0) continue;
                match = true;
                break;
            }
            for (Entity purchaser : purchasersL) {
                s1 = StringUtils.join(purchaser.words, "").toLowerCase();
                if (s1.indexOf(s) < 0) continue;
                match = true;
                break;
            }
            if (!match) continue;
            p -= (double)acqabr.words.size() * this.penalty1;
        }
        return p;
    }
}

