/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.util.StringUtils;
import java.util.List;

public abstract class NodePattern<T> {
    public static final NodePattern ANY_NODE = new AnyNodePattern();

    public abstract boolean match(T var1);

    public Object matchWithResult(T node) {
        if (this.match(node)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static class DisjNodePattern<T>
    extends NodePattern<T> {
        List<NodePattern<T>> nodePatterns;

        public DisjNodePattern(List<NodePattern<T>> nodePatterns) {
            this.nodePatterns = nodePatterns;
        }

        @Override
        public boolean match(T node) {
            boolean matched = false;
            for (NodePattern<T> p : this.nodePatterns) {
                if (!p.match(node)) continue;
                matched = true;
                break;
            }
            return matched;
        }

        public String toString() {
            return StringUtils.join(this.nodePatterns, " | ");
        }
    }

    public static class ConjNodePattern<T>
    extends NodePattern<T> {
        List<NodePattern<T>> nodePatterns;

        public ConjNodePattern(List<NodePattern<T>> nodePatterns) {
            this.nodePatterns = nodePatterns;
        }

        @Override
        public boolean match(T node) {
            boolean matched = true;
            for (NodePattern<T> p : this.nodePatterns) {
                if (p.match(node)) continue;
                matched = false;
                break;
            }
            return matched;
        }

        public String toString() {
            return StringUtils.join(this.nodePatterns, " & ");
        }
    }

    public static class NegateNodePattern<T>
    extends NodePattern<T> {
        NodePattern<T> p;

        public NegateNodePattern(NodePattern<T> p) {
            this.p = p;
        }

        @Override
        public boolean match(T node) {
            return !this.p.match(node);
        }

        public String toString() {
            return "!" + this.p;
        }
    }

    public static class AnyNodePattern<T>
    extends NodePattern<T> {
        protected AnyNodePattern() {
        }

        @Override
        public boolean match(T node) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }
}

