/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.tagger.maxent.History;
import java.util.ArrayList;

public class PairsHolder {
    private final ArrayList<WordTag> arr = new ArrayList();

    public void setSize(int s) {
        while (this.arr.size() < s) {
            this.arr.add(new WordTag(null, "NN"));
        }
    }

    public int getSize() {
        return this.arr.size();
    }

    void clear() {
        this.arr.clear();
    }

    void add(WordTag wordtag) {
        this.arr.add(wordtag);
    }

    void setWord(int pos, String word) {
        this.arr.get(pos).setWord(word);
    }

    void setTag(int pos, String tag) {
        this.arr.get(pos).setTag(tag);
    }

    String getTag(int position) {
        return this.arr.get(position).tag();
    }

    String getWord(int position) {
        return this.arr.get(position).word();
    }

    String getWord(History h, int position) {
        if (h.current + position >= h.start && h.current + position <= h.end) {
            return this.arr.get(h.current + position).word();
        }
        return "NA";
    }

    String getTag(History h, int position) {
        if (h.current + position >= h.start && h.current + position <= h.end) {
            return this.arr.get(h.current + position).tag();
        }
        return "NA";
    }
}

