/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.DependencyFactory;
import edu.stanford.nlp.trees.UnnamedDependency;
import edu.stanford.nlp.util.XMLUtils;

public class NamedDependency
extends UnnamedDependency {
    private static final long serialVersionUID = -1635646451505721133L;
    private final Object name;

    public NamedDependency(String regent, String dependent, Object name) {
        super(regent, dependent);
        this.name = name;
    }

    public NamedDependency(Label regent, Label dependent, Object name) {
        super(regent, dependent);
        this.name = name;
    }

    @Override
    public Object name() {
        return this.name;
    }

    @Override
    public int hashCode() {
        return this.regentText.hashCode() ^ this.dependentText.hashCode() ^ this.name.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamedDependency)) {
            return false;
        }
        NamedDependency d = (NamedDependency)o;
        return this.equalsIgnoreName(o) && this.name.equals(d.name);
    }

    @Override
    public String toString() {
        return String.format("%s --%s--> %s", this.regentText, this.name.toString(), this.dependentText);
    }

    @Override
    public String toString(String format) {
        if ("xml".equals(format)) {
            return "  <dep>\n    <governor>" + XMLUtils.escapeXML(this.governor().value()) + "</governor>\n    <dependent>" + XMLUtils.escapeXML(this.dependent().value()) + "</dependent>\n  </dep>";
        }
        if ("predicate".equals(format)) {
            return "dep(" + this.governor() + "," + this.dependent() + "," + this.name() + ")";
        }
        return this.toString();
    }

    @Override
    public DependencyFactory dependencyFactory() {
        return DependencyFactoryHolder.df;
    }

    public static DependencyFactory factory() {
        return DependencyFactoryHolder.df;
    }

    private static class NamedDependencyFactory
    implements DependencyFactory {
        private NamedDependencyFactory() {
        }

        @Override
        public Dependency<Label, Label, Object> newDependency(Label regent, Label dependent) {
            return this.newDependency(regent, dependent, null);
        }

        @Override
        public Dependency<Label, Label, Object> newDependency(Label regent, Label dependent, Object name) {
            return new NamedDependency(regent, dependent, name);
        }
    }

    private static class DependencyFactoryHolder {
        private static final DependencyFactory df = new NamedDependencyFactory();

        private DependencyFactoryHolder() {
        }
    }
}

