/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.logging.Redwood;
import java.io.PrintStream;
import java.util.Locale;

public class RedwoodPrintStream
extends PrintStream {
    private final Redwood.Flag tag;
    private final PrintStream realStream;
    private StringBuilder buffer = new StringBuilder();
    private boolean checkForThrowable = false;

    public RedwoodPrintStream(Redwood.Flag tag, PrintStream realStream) {
        super(realStream);
        this.tag = tag;
        this.realStream = realStream;
    }

    private void log(Object message) {
        if (this.buffer.length() > 0) {
            this.logB(message);
            this.logB("\n");
        } else if (this.tag != null) {
            Redwood.log(new Object[]{this.tag, message});
        } else {
            Redwood.log(message);
        }
    }

    private void logf(String format, Object[] args) {
        if (this.tag != null) {
            Redwood.channels(new Object[]{this.tag}).logf(format, args);
        } else {
            Redwood.logf(format, args);
        }
    }

    private void logB(Object message) {
        char[] str;
        for (char c : str = message.toString().toCharArray()) {
            if (c == '\n') {
                String msg = this.buffer.toString();
                if (this.tag != null) {
                    Redwood.log(new Object[]{this.tag, msg});
                } else {
                    Redwood.log(msg);
                }
                this.buffer = new StringBuilder();
                continue;
            }
            this.buffer.append("" + c);
        }
    }

    @Override
    public void flush() {
        this.realStream.flush();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean checkError() {
        return false;
    }

    @Override
    protected void setError() {
    }

    @Override
    protected void clearError() {
    }

    @Override
    public void print(boolean b) {
        this.logB(b);
    }

    @Override
    public void print(char c) {
        this.logB(Character.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.logB(i);
    }

    @Override
    public void print(long l) {
        this.logB(l);
    }

    @Override
    public void print(float f) {
        this.logB(Float.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.logB(d);
    }

    @Override
    public void print(char[] chars) {
        this.logB(new String(chars));
    }

    @Override
    public void print(String s) {
        this.logB(s);
    }

    @Override
    public void print(Object o) {
        this.logB(o);
    }

    @Override
    public void println(boolean b) {
        this.log(b);
    }

    @Override
    public void println(char c) {
        this.log(Character.valueOf(c));
    }

    @Override
    public void println(int i) {
        this.log(i);
    }

    @Override
    public void println(long l) {
        this.log(l);
    }

    @Override
    public void println(float f) {
        this.log(Float.valueOf(f));
    }

    @Override
    public void println(double d) {
        this.log(d);
    }

    @Override
    public void println(char[] chars) {
        this.log(new String(chars));
    }

    @Override
    public void println(String s) {
        if (this.checkForThrowable) {
            boolean fromThrowable = false;
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                if (!e.getClassName().equals(Throwable.class.getName())) continue;
                fromThrowable = true;
            }
            if (fromThrowable) {
                this.realStream.println(s);
            } else {
                this.log(s);
                this.checkForThrowable = false;
            }
        } else {
            this.log(s);
        }
    }

    @Override
    public void println(Object o) {
        if (o instanceof Throwable) {
            this.realStream.println(o);
            this.flush();
            this.checkForThrowable = true;
        } else {
            this.log(o);
        }
    }

    @Override
    public void println() {
        this.log("");
    }

    @Override
    public PrintStream printf(String s, Object ... objects) {
        this.logf(s, objects);
        return this;
    }

    @Override
    public PrintStream printf(Locale locale, String s, Object ... objects) {
        this.logf(s, objects);
        return this;
    }

    @Override
    public PrintStream format(String s, Object ... objects) {
        this.logf(s, objects);
        return this;
    }

    @Override
    public PrintStream format(Locale locale, String s, Object ... objects) {
        this.logf(s, objects);
        return this;
    }

    @Override
    public PrintStream append(CharSequence charSequence) {
        this.logB(charSequence);
        return this;
    }

    @Override
    public PrintStream append(CharSequence charSequence, int i, int i1) {
        this.logB(charSequence.subSequence(i, i1));
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.logB(Character.valueOf(c));
        return this;
    }
}

