use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

#
# Options:
#
#	--with-gdkimblib
#	--with-gtkxmhtml
#	--with-gtktty
#	--with-gnome  
#

$AUTOLOAD_GTK_CLASSES = 0; # Experimental stuff

@defs = ();
@headers = ();
$libs = `gtk-config --libs`;
$libs = "-L/usr/X11R6/lib -lgtk -lgdk -lglib -lX11 -lXext" if not defined $libs;

$inc = `gtk-config --cflags`;


$object = 'Gtk.o GtkDefs.o GtkTypes.o GdkTypes.o MiscTypes.o';
$typemap = ["typemap.gtk"];
$pm = {'Gdk.pm' => '$(INST_LIBDIR)/Gtk/Gdk.pm',
	'Gtk.pm' => '$(INST_LIBDIR)/Gtk.pm',
	'GtkTypes.pm' => '$(INST_LIBDIR)/Gtk/Types.pm',
	'Atoms.pm' => '$(INST_LIBDIR)/Gtk/Atoms.pm',
	'GtkColorSelectButton.pm' => '$(INST_LIBDIR)/Gtk/ColorSelectButton.pm',
};

@clean = qw(GtkTypes.pm typemap.gtk GtkDefs.c GtkDefs.h Objects.xpl boxed.xsh extension.xsh inc.h objects.xsh);

$xfiles = {};
foreach (<*.xs>) {
	my $xs = $_;
	s/\.xs$/.c/;
	$xfiles->{$xs} = $_;
}

open (EXT, ">extension.xsh");
print EXT "\n\n# Do not edit this file, as it is automatically generated by Makefile.PL\n\n";
print EXT "BOOT:\n{\n";

if (grep {/^--with-gdkimlib/i} @ARGV) {
	$object .= ' GdkImlib.o ';
	push(@$typemap, 'typemap.gdkimlib');
	push(@defs, 'gdkimlib.defs.maybe');
	# we need to know what libraries are used by the
	# gdk_imlib lib we are going to link to....
	$libs =~ s/-l/-lgdk_imlib -lgif -ltiff -lpng -ljpeg -lz -l/; # hack hack
	push(@boot_code,"boot_Gtk__Gdk__ImlibImage");
} else {
	delete $xfiles->{'GdkImlib.xs'};
	push @clean, "GdkImlib.c";
}

if (grep {/^--with-gtkxmhtml/i} @ARGV) {
	#$object .= ' GtkXmHTML.o ';
	push(@$typemap, 'typemap.gtkxmhtml');
	push(@defs, 'gtkxmhtml.defs.maybe');
	# we need to know what libraries are used by the
	# gtkxmhtml lib we are going to link to....
	$libs =~ s/-l/-lgtkxmhtml -lXpm -lpng -ljpeg -lz -l/; # hack hack
	#print EXT boot_code("boot_Gtk__XmHTML");
} else {
	delete $xfiles->{'GtkXmHTML.xs'};
	push @clean, "GtkXmHTML.c";

}

if (grep {/^--with-gtktty/i} @ARGV) {
	#$object .= ' GtkXmHTML.o ';
	push(@$typemap, 'typemap.gtktty');
	push(@defs, 'gtktty.defs.maybe');
	push(@headers, '<gtktty/gtktty.h>');
	# we need to know what libraries are used by the
	# gtktty lib we are going to link to....
	$libs =~ s/-l/-lgtktty -l/; # hack hack
	#print EXT boot_code("boot_Gtk__XmHTML");
} else {
	foreach (qw(
		GtkLed	GtkTty	GtkTerm	GtkVtEmu
	)) {
		delete $xfiles->{"$_.xs"};
		push @clean, "$_.c"
	}
}

if (grep {/^--with-gnome/i} @ARGV) {
	$object .= ' Gnome.o ';
	push(@$typemap, 'typemap.gnome');
	push(@defs, 'gnome.defs.maybe');
	push(@headers, "<libgnomesupport/argp.h>", "<libgnomeui/libgnomeui.h>");
	$pm->{'Gnome.pm'} = '$(INST_LIBDIR)/Gtk/Gnome.pm';
	# use gnomeConf.sh...
	$libs =~ s/-l/-lgnome -lgnomesupport -lintl -lgnomeui -lSM -lICE -l/; #hack hack
	push(@boot_code, "boot_Gtk__Gnome");
} else {
	foreach (qw(
		GnomeAbout         GnomeClient        GnomeFontSelector  GnomePixmap	  Gnome 
		GnomeApp           GnomeEntry         GnomeMessageBox    GnomeScores
		GtkTed
		GtkClock
	)) {
		delete $xfiles->{"$_.xs"};
		push @clean, "$_.c";
		
	}
}


foreach (@boot_code) {
	print EXT "extern void $_(CV *cv);\n";
}

foreach (@boot_code) {
	print EXT "callXS($_, cv, mark);\n";
}

print EXT "}\n";
close(EXT);

open(I, ">inc.h");
print I "\n\n/* Do not edit this file, as it is automatically generated by Makefile.PL*/\n\n";
foreach (@headers) {
	print I "#include $_\n";
}
close(I);

#print "Running gendefs.pl @defs\n";

system('perl', 'gendefs.pl', @defs);
$object .= " " . (do 'Objects.xpl');


@L = (LIBS => [$libs]);

if (defined $inc and $inc !~ /^\s*$/) {
	@I = (INC => $inc);
} else {
	@I = (); #e.g, INC => -I/usr/other/include
}

WriteMakefile(
    'NAME'	=> 'Gtk',
    'VERSION_FROM'	=> 'Gtk.pm',
    'PM' => $pm,
    'TYPEMAPS' => $typemap,
    'XS' => $xfiles,
    'XSOPT' => '-noversioncheck',
    'DEFINE'	=> $AUTOLOAD_GTK_CLASSES ? '-DAUTOLOAD_GTK_CLASSES' : '',
    'OBJECT' => $object,
	'XSPROTOARG' => '-noprototypes',
	realclean => {FILES => join(' ', @clean)},


	@I,
	@L,
);
