package App::git_log_ch_usrdata;

use strict;
use warnings;

our $VERSION = '0.02';


1;


__END__

=head1 NAME

App::git_log_ch_usrdata - Change username and email address in git log

=head1 VERSION

Version 0.02


=head1 DESCRIPTION

The username and email address in the Git log can be changed with
L<git_log_ch_usrdata>. For more information, see the documentation for this
script.


=head1 AUTHOR

Klaus Rindfrey, C<< <klausrin at cpan.org.eu> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-app-git_log_ch_usrdata at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/NoAuth/ReportBug.html?Queue=App-git_log_ch_usrdata>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.


=head1 SEE ALSO

L<App::ghmulti>, L<git_log_ch_usrdata>


=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc App::git_log_ch_usrdata


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<https://rt.cpan.org/NoAuth/Bugs.html?Dist=App-git_log_ch_usrdata>

=item * Search CPAN

L<https://metacpan.org/release/App-git_log_ch_usrdata>

=item * GitHub Repository

L<https://github.com/klaus-rindfrey/perl-app-git_log_ch_usrdata>

=back


=head1 LICENSE AND COPYRIGHT

This software is copyright (c) 2025 by Klaus Rindfrey.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

