package IO::Iron::ConnectorBase;

## no critic (Documentation::RequirePodAtEnd)
## no critic (Documentation::RequirePodSections)

use 5.010_000;
use strict;
use warnings;

# Global creator
BEGIN {
    # Export nothing.
}

# Global destructor
END {
}

# ABSTRACT: Base class for the REST API Connector, HTTP interface class.

our $VERSION = '0.14'; # VERSION: generated by DZP::OurPkgVersion

use Log::Any qw{$log};
use Hash::Util 0.06 qw{lock_keys unlock_keys};
use Carp;
use Carp::Assert;
use Carp::Assert::More;
use English '-no_match_vars';
use Scalar::Util qw{blessed};

# DEFAULTS

sub new {
    my ($class) = @_;
    $log->tracef( 'Entering new(%s)', $class );
    my $self      = {};
    my @self_keys = (     ### no critic (CodeLayout::ProhibitQuotedWordLists)
                          # No keys.
    );

    bless $self, $class;
    lock_keys( %{$self}, @self_keys );

    $log->tracef( 'Exiting new: %s', $self );
    return $self;
}

# Connector needs:
# all API info
# params for API.href     => if it's a mock!
# message body
# headers: content type, authorization
# connection params: timeout?, retry?
# Connector arranges by inself:
# HTTP REST connection: REST::Client / LWP

sub perform_iron_action {

    #my ($self, $iron_action, $params) = @_;
    #if(!defined $params){
    #	$params = {};
    #}
    #$log->tracef('Entering ConnectorBase:perform_iron_action(%s, %s)', $iron_action, $params);

    croak('This routine must be replaced in the inheriting sub class.');

    #my ($returned_msg, $http_status_code);
    #$log->tracef('Exiting ConnectorBase:perform_iron_action(): %s', $returned_msg );
    #return $http_status_code, $returned_msg;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::Iron::ConnectorBase - Base class for the REST API Connector, HTTP interface class.

=head1 VERSION

version 0.14

=head1 SYNOPSIS

This package is for internal use of IO::Iron packages.

=head1 DESCRIPTION

=for stopwords Params params API Mikko Koivunalho TODO

=head1 SUBROUTINES/METHODS

=head2 new

Creator function.

=head2 perform_iron_action

=over 8

=item Params: action name, params hash.

=item Return: 1/0 (1 if success, 0 in all failures),
HTTP return code, hash if success/failed request.
If you need to create your own Connector class, start with copying
this routine.

=back

=head1 AUTHOR

Mikko Koivunalho <mikko.koivunalho@iki.fi>

=head1 BUGS

Please report any bugs or feature requests to bug-io-iron@rt.cpan.org or through the web interface at:
 http://rt.cpan.org/Public/Dist/Display.html?Name=IO-Iron

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by Mikko Koivunalho.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

The full text of the license can be found in the
F<LICENSE> file included with this distribution.

=cut
