#!/usr/bin/env perl 
#
# Before `make install' is performed this script should be runnable with
# `make test'.
# After `make install' it should work as `perl 500_Slurm-SAAccount-parse.t'
use strict;
use warnings;

use Test::More;
use Cwd qw(abs_path);
use File::Basename qw(dirname);

use Slurm::Sacctmgr;
use Slurm::Sacctmgr::Account;

my $testDir = dirname(abs_path($0));
my $num_tests_run = 0; 

#Set up expected results
my @fakedata =
(	
	{ acct=>'aaa', desc=>'test account 1', org=>'aa' },
	{ acct=>'aab', desc=>'test account 1b', org=>'aa' },
	{ acct=>'bbb', desc=>'test account 2', org=>'bb' },
	{ acct=>'ccc', desc=>'test account 3', org=>'cc' },
);
my @fake_data = ();
foreach my $fakedatum (@fakedata)
{	my $acct = $fakedatum->{acct};
	my $desc = $fakedatum->{desc};
	my $org = $fakedatum->{org};

	my $obj = new_ok('Slurm::Sacctmgr::Account' => 
		[ account => $acct, description => $desc, organization => $org ],
		"$acct" );
	$num_tests_run++;

	push @fake_data, $obj;
}
#Make sure @fake_data is alphabetically by username
@fake_data = sort { $a->account cmp $b->account } @fake_data;

my $sa = Slurm::Sacctmgr->new(sacctmgr=>"${testDir}/helpers/fake_sacctmgr_acct");
my $saacct = 'Slurm::Sacctmgr::Account';

my $results;
my $args;
my $temp;
my $val;
my @temp;

#Test various commands with echo sacctmgr
#$sa->verbose(1);

$results = $saacct->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all accts');
$num_tests_run++;

$val = 'bbb';
@temp = ( name => $val );
$temp = [ grep { $_->account eq $val } @fake_data ];
$results = $saacct->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list acct by name');
$num_tests_run++;

$val = 'bb';
@temp = ( organization => $val );
$temp = [ grep { $_->organization eq $val } @fake_data ];
$results = $saacct->sacctmgr_list($sa, @temp);
is_deeply($results, $temp, 'list acct by org (single acct)');
$num_tests_run++;

$val = 'aa';
@temp = ( organization => $val );
$temp = [ grep { $_->organization eq $val } @fake_data ];
$results = $saacct->sacctmgr_list($sa, @temp);
is_deeply($results, $temp, 'list acct by org (multiple accts)');
$num_tests_run++;

$val = 'aa';
@temp = ( organization => $val );
$temp = [ grep { $_->organization eq $val } @fake_data ];
$val = 'test account 1b';
push @temp, ( description => $val );
$temp = [ grep { $_->description eq $val } @$temp ];
$results = $saacct->sacctmgr_list($sa, @temp);
is_deeply($results, $temp, 'list acct by org and desc');
$num_tests_run++;

#Test for match failing
$val = 'zzz';
@temp = ( name => $val );
$temp = [ grep { $_->account eq $val } @fake_data ];
$results = $saacct->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list acct by name (no match)');
$num_tests_run++;

#Test that still works when in dryrun mode
$sa->dryrun(1);
$results = $saacct->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all accts (dryrun)');
$num_tests_run++;

done_testing($num_tests_run);

