/*
 * Decompiled with CFR 0.152.
 */
package opennlp.common.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Element;

public class XmlUtils {
    public static String filt2XML(String s) {
        StringBuffer input = new StringBuffer(s);
        StringBuffer output = new StringBuffer(input.length());
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            switch (c) {
                case '<': {
                    output.append("&lt;");
                    break;
                }
                case '>': {
                    output.append("&gt;");
                    break;
                }
                case '&': {
                    output.append("&amp;");
                    break;
                }
                case '\'': {
                    output.append("&apos;");
                    break;
                }
                case '\"': {
                    output.append("&quot;");
                    break;
                }
                default: {
                    output.append(c);
                }
            }
            ++i;
        }
        return output.toString();
    }

    public static String getAllTextNested(Element e) {
        StringBuffer sb = new StringBuffer();
        sb.append(e.getText());
        List children = e.getChildren();
        if (children.size() > 0) {
            sb.append(' ');
        }
        Iterator i = children.iterator();
        while (i.hasNext()) {
            sb.append(XmlUtils.getAllTextNested((Element)i.next())).append(' ');
        }
        return sb.toString().trim();
    }

    public static String getChildTextNested(Element e, String name) {
        StringBuffer sb = new StringBuffer();
        List children = e.getChildren();
        if (e.getName().equals(name)) {
            sb.append(e.getText());
            if (children.size() > 0) {
                sb.append(' ');
            }
        }
        Iterator i = children.iterator();
        while (i.hasNext()) {
            sb.append(XmlUtils.getChildTextNested((Element)i.next(), name)).append(' ');
        }
        return sb.toString().trim();
    }

    public static List getChildrenNested(Element e, String name) {
        ArrayList<Element> elements = new ArrayList<Element>();
        List children = e.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Element c = (Element)i.next();
            if (c.getName().equals(name)) {
                elements.add(c);
                continue;
            }
            elements.addAll(XmlUtils.getChildrenNested(c, name));
        }
        return elements;
    }

    public static void insertAfter(Element old, Element toInsert) {
        Element parent = old.getParent();
        List children = parent.getChildren();
        ArrayList $children = new ArrayList(children.size() + 1);
        ListIterator i = children.listIterator();
        while (i.hasNext()) {
            Object $_ = i.next();
            $children.add($_);
            if ($_ != old) continue;
            $children.add(toInsert);
        }
        parent.removeChildren();
        parent.setChildren($children);
    }

    public static void replace(Element old, List replacements) {
        Element parent = old.getParent();
        List children = parent.getChildren();
        ArrayList $children = new ArrayList(children.size() + replacements.size());
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object $_ = i.next();
            if ($_ == old) {
                $children.addAll(replacements);
                continue;
            }
            $children.add($_);
        }
        parent.removeChildren();
        parent.setChildren($children);
    }

    public static void replace(Element old, Element replacement) {
        Element parent = old.getParent();
        List children = parent.getChildren();
        ListIterator<Element> i = children.listIterator();
        while (i.hasNext()) {
            if (i.next() != old) continue;
            i.set(replacement);
        }
    }

    public static void replace(Element old, Element replacement, int oldElementsToSkip) {
        Element parent = old.getParent();
        List children = parent.getChildren();
        ArrayList<Object> $children = new ArrayList<Object>(children.size() - oldElementsToSkip);
        ListIterator i = children.listIterator();
        while (i.hasNext()) {
            Object $_ = i.next();
            if ($_ == old) {
                $children.add(replacement);
                while (oldElementsToSkip > 0) {
                    i.next();
                    --oldElementsToSkip;
                }
                continue;
            }
            $children.add($_);
        }
        parent.removeChildren();
        parent.setChildren($children);
    }
}

