# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package AddressBook::GEN::Address;

use strict;

use base 'AddressBook';

use AddressBook::Model::address qw(
    $ADDRESS
);

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Address' );

    my $retval = {
        headings       => [
            'Name',
            'Number',
            'Email',
        ],
        header_options => [
            {
                text => 'Add',
                link => $self->location() . "/add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $ADDRESS->get_listing( { schema => $schema } );

    foreach my $row ( @rows ) {
        my $id = $row->id;
        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->name,
                    $row->number,
                    $row->email,
                ],
                options => [
                    {
                        text => 'Edit',
                        link => $self->location() . "/edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $self->location() . "/delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $ADDRESS->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        fields     => [
            {
                name => 'name',
                optional => 0,
                label => 'Name',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'number',
                optional => 1,
                label => 'Number',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'street',
                optional => 1,
                label => 'Street',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'city',
                optional => 1,
                label => 'City',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'state',
                optional => 1,
                label => 'State',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'zip',
                optional => 1,
                label => 'Zip',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'email',
                optional => 1,
                label => 'Email',
                type => 'text',
                is => 'varchar',
            },
        ],
    };
} # END form


1;

=head1 NAME

AddressBook::GEN::Address - generated support module for AddressBook::Address

=head1 SYNOPSIS

In AddressBook::Address:

    use AddressBook::GEN::Address qw(
        do_main
        form
    );

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in AddressBook::Address to provide the methods below.
They are exported by default.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

