package Microsoft::AdCenter::V6::ReportingService::SearchQueryPerformanceReportColumn;
# Copyright (C) 2012 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V6::ReportingService::SearchQueryPerformanceReportColumn - Represents "SearchQueryPerformanceReportColumn" in Microsoft AdCenter Reporting Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    AccountId
    AccountName
    AccountNumber
    AdGroupId
    AdGroupName
    AdId
    AdStatus
    AdType
    AverageCpc
    AveragePosition
    CampaignId
    CampaignName
    CampaignStatus
    Clicks
    Ctr
    DestinationUrl
    Impressions
    LanguageAndRegion
    MatchType
    SearchQuery
    Spend
    TimePeriod

=cut

sub AccountId {
    return 'AccountId';
}

sub AccountName {
    return 'AccountName';
}

sub AccountNumber {
    return 'AccountNumber';
}

sub AdGroupId {
    return 'AdGroupId';
}

sub AdGroupName {
    return 'AdGroupName';
}

sub AdId {
    return 'AdId';
}

sub AdStatus {
    return 'AdStatus';
}

sub AdType {
    return 'AdType';
}

sub AverageCpc {
    return 'AverageCpc';
}

sub AveragePosition {
    return 'AveragePosition';
}

sub CampaignId {
    return 'CampaignId';
}

sub CampaignName {
    return 'CampaignName';
}

sub CampaignStatus {
    return 'CampaignStatus';
}

sub Clicks {
    return 'Clicks';
}

sub Ctr {
    return 'Ctr';
}

sub DestinationUrl {
    return 'DestinationUrl';
}

sub Impressions {
    return 'Impressions';
}

sub LanguageAndRegion {
    return 'LanguageAndRegion';
}

sub MatchType {
    return 'MatchType';
}

sub SearchQuery {
    return 'SearchQuery';
}

sub Spend {
    return 'Spend';
}

sub TimePeriod {
    return 'TimePeriod';
}

1;
