# Generated by default/object.tt
package Paws::Route53Resolver::FirewallDomainListMetadata;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has CreatorRequestId => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str');
  has ManagedOwnerName => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Route53Resolver::FirewallDomainListMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Route53Resolver::FirewallDomainListMetadata object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Route53Resolver::FirewallDomainListMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Minimal high-level information for a firewall domain list. The action
ListFirewallDomainLists returns an array of these objects.

To retrieve full information for a firewall domain list, call
GetFirewallDomainList and ListFirewallDomains.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the firewall domain list metadata.


=head2 CreatorRequestId => Str

A unique string defined by you to identify the request. This allows you
to retry failed requests without the risk of running the operation
twice. This can be any unique string, for example, a timestamp.


=head2 Id => Str

The ID of the domain list.


=head2 ManagedOwnerName => Str

The owner of the list, used only for lists that are not managed by you.
For example, the managed domain list
C<AWSManagedDomainsMalwareDomainList> has the managed owner name
C<Route 53 Resolver DNS Firewall>.


=head2 Name => Str

The name of the domain list.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Route53Resolver>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

