# Generated by default/object.tt
package Paws::S3Control::S3InitiateRestoreObjectOperation;
  use Moose;
  has ExpirationInDays => (is => 'ro', isa => 'Int');
  has GlacierJobTier => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3Control::S3InitiateRestoreObjectOperation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3Control::S3InitiateRestoreObjectOperation object:

  $service_obj->Method(Att1 => { ExpirationInDays => $value, ..., GlacierJobTier => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3Control::S3InitiateRestoreObjectOperation object:

  $result = $service_obj->Method(...);
  $result->Att1->ExpirationInDays

=head1 DESCRIPTION

Contains the configuration parameters for an S3 Initiate Restore Object
job. S3 Batch Operations passes every object to the underlying POST
Object restore API. For more information about the parameters for this
operation, see RestoreObject
(https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html#RESTObjectPOSTrestore-restore-request).

=head1 ATTRIBUTES


=head2 ExpirationInDays => Int

This argument specifies how long the S3 Glacier or S3 Glacier Deep
Archive object remains available in Amazon S3. S3 Initiate Restore
Object jobs that target S3 Glacier and S3 Glacier Deep Archive objects
require C<ExpirationInDays> set to 1 or greater.

Conversely, do I<not> set C<ExpirationInDays> when creating S3 Initiate
Restore Object jobs that target S3 Intelligent-Tiering Archive Access
and Deep Archive Access tier objects. Objects in S3 Intelligent-Tiering
archive access tiers are not subject to restore expiry, so specifying
C<ExpirationInDays> results in restore request failure.

S3 Batch Operations jobs can operate either on S3 Glacier and S3
Glacier Deep Archive storage class objects or on S3 Intelligent-Tiering
Archive Access and Deep Archive Access storage tier objects, but not
both types in the same job. If you need to restore objects of both
types you I<must> create separate Batch Operations jobs.


=head2 GlacierJobTier => Str

S3 Batch Operations supports C<STANDARD> and C<BULK> retrieval tiers,
but not the C<EXPEDITED> retrieval tier.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3Control>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

