#!perl
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/test-dist-zilla-exception.t
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Test-Dist-Zilla.
#
#   perl-Test-Dist-Zilla is free software: you can redistribute it and/or modify it under the terms
#   of the GNU General Public License as published by the Free Software Foundation, either version
#   3 of the License, or (at your option) any later version.
#
#   perl-Test-Dist-Zilla is distributed in the hope that it will be useful, but WITHOUT ANY
#   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#   PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Test-Dist-Zilla. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

use if $ENV{AUTOMATED_TESTING}, 'Test::DiagINC';
use Test::Routine;
with 'Test::Dist::Zilla';

use Test::Fatal;
use Test::More;
use Test::Routine::Util;
use Test::Deep qw{ cmp_deeply };

test 'Exception' => sub {

    my ( $self ) = @_;
    my $expected = $self->expected;

    plan tests => 5;

    my ( $tzil, $exception );

    is( $self->exception, undef, 'attr initially undefined' );

    # Construction Dist::Zilla does not throw exception.
    $exception = exception { $tzil = $self->tzil; };
    is( $exception, undef, 'not thrown' );
    ok( blessed( $tzil ), '$tzil is an object' );

    # Building does not throw exception too, but sets `exception` attribute.
    $exception = exception { $self->build(); };
    is ( $exception, undef, 'not thrown again' );
    like( $self->exception, qr{\Q!@#%^&*()_+\E}, 'exception attr' );

};

# --------------------------------------------------------------------------------------------------

plan tests => 1;

run_me 'exception' => {
    plugins => [
        '!@#%^&*()_+',  # This is invalid plugin name.
    ],
    expected => {
    },
};

done_testing;

exit( 0 );

# end of file #
