/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.couchbase.mock.memcached.protocol.CommandCode;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class ClientResponse {
    private CommandCode code;
    private ErrorCode status;
    private ByteBuffer extras;
    private ByteBuffer key;
    private ByteBuffer value;
    private byte[] body;
    private int opaque;
    long cas;

    public long getCas() {
        return this.cas;
    }

    public long getOpaque() {
        return this.opaque;
    }

    public String getKey() {
        return new String(this.key.array());
    }

    public String getValue() {
        return new String(this.value.array());
    }

    public ByteBuffer getRawValue() {
        return this.value.asReadOnlyBuffer();
    }

    public byte[] getExtras() {
        return this.extras.array();
    }

    public ErrorCode getStatus() {
        return this.status;
    }

    public boolean success() {
        return this.status == ErrorCode.SUCCESS;
    }

    public static ClientResponse read(InputStream input) throws IOException {
        int nr;
        int remaining;
        int nr2;
        byte[] header = new byte[24];
        for (remaining = header.length; remaining > 0 && (nr2 = input.read(header, header.length - remaining, remaining)) != -1; remaining -= nr2) {
        }
        if (remaining > 0) {
            throw new IOException("Incomplete read before stream closed");
        }
        ByteBuffer buf = ByteBuffer.wrap(header);
        byte magic = buf.get();
        if (magic != -127) {
            throw new IOException("Illegal magic: " + magic);
        }
        ClientResponse ret = new ClientResponse();
        ret.code = CommandCode.valueOf(buf.get());
        if (ret.code == CommandCode.ILLEGAL) {
            throw new IOException("Illegal command");
        }
        short keylen = buf.getShort();
        byte extlen = buf.get();
        buf.get();
        ret.status = ErrorCode.valueOf(buf.getShort());
        int totalLen = buf.getInt();
        ret.opaque = buf.getInt();
        ret.cas = buf.getLong();
        ret.body = new byte[totalLen];
        ret.extras = ByteBuffer.wrap(ret.body, 0, extlen);
        ret.key = ByteBuffer.wrap(ret.body, extlen, keylen);
        ret.value = ByteBuffer.wrap(ret.body, extlen + keylen, totalLen - (extlen + keylen));
        for (remaining = ret.body.length; remaining > 0; remaining -= nr) {
            nr = input.read(ret.body, ret.body.length - remaining, remaining);
            if (nr >= 0) continue;
            throw new IOException("Incomplete read");
        }
        return ret;
    }
}

