# Generated by default/object.tt
package Paws::AuditManager::Assessment;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has AwsAccount => (is => 'ro', isa => 'Paws::AuditManager::AWSAccount', request_name => 'awsAccount', traits => ['NameInRequest']);
  has Framework => (is => 'ro', isa => 'Paws::AuditManager::AssessmentFramework', request_name => 'framework', traits => ['NameInRequest']);
  has Metadata => (is => 'ro', isa => 'Paws::AuditManager::AssessmentMetadata', request_name => 'metadata', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::AuditManager::TagMap', request_name => 'tags', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::Assessment

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::Assessment object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::Assessment object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

An entity that defines the scope of audit evidence collected by AWS
Audit Manager. An AWS Audit Manager assessment is an implementation of
an AWS Audit Manager framework.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the assessment.


=head2 AwsAccount => L<Paws::AuditManager::AWSAccount>

The AWS account associated with the assessment.


=head2 Framework => L<Paws::AuditManager::AssessmentFramework>

The framework from which the assessment was created.


=head2 Metadata => L<Paws::AuditManager::AssessmentMetadata>

The metadata for the specified assessment.


=head2 Tags => L<Paws::AuditManager::TagMap>

The tags associated with the assessment.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

