# Generated by default/object.tt
package Paws::SSMContacts::Plan;
  use Moose;
  has Stages => (is => 'ro', isa => 'ArrayRef[Paws::SSMContacts::Stage]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMContacts::Plan

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMContacts::Plan object:

  $service_obj->Method(Att1 => { Stages => $value, ..., Stages => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMContacts::Plan object:

  $result = $service_obj->Method(...);
  $result->Att1->Stages

=head1 DESCRIPTION

The stages that an escalation plan or engagement plan engages contacts
and contact methods in.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Stages => ArrayRef[L<Paws::SSMContacts::Stage>]

A list of stages that the escalation plan or engagement plan uses to
engage contacts and contact methods.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMContacts>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

