# Generated by default/object.tt
package Paws::S3Control::StorageLensConfiguration;
  use Moose;
  has AccountLevel => (is => 'ro', isa => 'Paws::S3Control::AccountLevel', required => 1);
  has AwsOrg => (is => 'ro', isa => 'Paws::S3Control::StorageLensAwsOrg');
  has DataExport => (is => 'ro', isa => 'Paws::S3Control::StorageLensDataExport');
  has Exclude => (is => 'ro', isa => 'Paws::S3Control::Exclude');
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has Include => (is => 'ro', isa => 'Paws::S3Control::Include');
  has IsEnabled => (is => 'ro', isa => 'Bool', required => 1);
  has StorageLensArn => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3Control::StorageLensConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3Control::StorageLensConfiguration object:

  $service_obj->Method(Att1 => { AccountLevel => $value, ..., StorageLensArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3Control::StorageLensConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountLevel

=head1 DESCRIPTION

A container for the Amazon S3 Storage Lens configuration.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AccountLevel => L<Paws::S3Control::AccountLevel>

A container for all the account-level configurations of your S3 Storage
Lens configuration.


=head2 AwsOrg => L<Paws::S3Control::StorageLensAwsOrg>

A container for the AWS organization for this S3 Storage Lens
configuration.


=head2 DataExport => L<Paws::S3Control::StorageLensDataExport>

A container to specify the properties of your S3 Storage Lens metrics
export including, the destination, schema and format.


=head2 Exclude => L<Paws::S3Control::Exclude>

A container for what is excluded in this configuration. This container
can only be valid if there is no C<Include> container submitted, and
it's not empty.


=head2 B<REQUIRED> Id => Str

A container for the Amazon S3 Storage Lens configuration ID.


=head2 Include => L<Paws::S3Control::Include>

A container for what is included in this configuration. This container
can only be valid if there is no C<Exclude> container submitted, and
it's not empty.


=head2 B<REQUIRED> IsEnabled => Bool

A container for whether the S3 Storage Lens configuration is enabled.


=head2 StorageLensArn => Str

The Amazon Resource Name (ARN) of the S3 Storage Lens configuration.
This property is read-only and follows the following format: C<
arn:aws:s3:I<us-east-1>:I<example-account-id>:storage-lens/I<your-dashboard-name>>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3Control>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

