.COMMENT SccsID: @(#) Xop.man 1.1 92/03/18 11:15:01
.TH "Xop" 1 "1 March 1992"
.SH NAME
Xop \- OpenLook Public Library
.SH SYNOPSIS
.ta 1.5i 2.5i
.nf
.ft B
#include <X11/Intrinsic.h>
#include <X11/Wc/WcCreate.h>
#include <X11/Xop/Xop.h>

/* All Wcl applications should provide at least the Wcl options:
*/
static XrmOptionDescRec options[] = {
    ... application specific command line options ...
    WCL_XRM_OPTIONS
};

main ( argc, argv )
    int    argc;
    char*  argv[];
{
    /*  -- Intialize Toolkit creating the application shell
    */
    Widget appShell = XtInitialize (
        argv[0], WcAppClass( argc, argv ),      /* app name & class  */
        options, XtNumber(options),             /* argv option descr */
        &argc, argv
    );
    XtAppContext app = XtWidgetToApplicationContext(appShell);

    /*  -- Register application specific callbacks and widget classes
    */
    RegisterApplication ( app );

    /*  -- Register all widget classes and constructors
    */
    XopRegisterOpenLook( app );

    /*  -- Create widget tree below toplevel shell using Xrm database
    */
    if ( WcWidgetCreation ( appShell ) )
        exit(1);

    /*  -- Realize the widget tree
    */
    XtRealizeWidget ( appShell );

    /*  -- and finally, enter the main application loop
    */
    XtMainLoop ( );
}
.fi
.ft R

.SH LINK BY
.RS
.nf
.ft B
example% ld -o prog prog.o -lXop -lXol -lWc <dynLinkLib> -lXmu -lXt -lX11
.ft R
.RE
.LP 
On SunOS or SVR4 machines, the <dynLinkLib> is named -ldl.
Other architectures cannot use the dynamic linking capabilites of
Wcl, and therefore do not need any dynamic link library.
.SH DESCRIPTION
.LP
.I Xop
is intended to be used with
.I Wcl
and the OpenLook widget set.  Xop provides a procedure for registering all
OpenLook widgets, and also includes the XpTableWidget.
.SH REGISTRATION PROCEDURES
.LP
.I Wcl
must be told the names of all widgets and widget constructors before
it can create widgets as specified in the resource file of client
applications.
.I Xop
provides a registration procedure for registering all OpenLook widgets.
For backward compatibility with previous releases of Wcl, this
registration procedure has three names: OriRegisterOpenLook(), 
XopRegisterAll(), and XopRegisterOpenLook().  These procedures
are exactly equivalent.
.TP
.B void XopRegisterOpenLook( XtAppContext )
This procedure registers all of the OpenLook widget class pointer names
and widget class names with Wcl.
.SH "SEE ALSO"
.BI XpTable (3),
.BI Ori (1),	
.BI Wcl (3),
.BI X (1)
.SH AUTHORS
Kim Gillies (gillies@noao.edu) did most of the work of implementing
Xop, and David E. Smyth (David.Smyth@sniap.mchp.sni.de) at Siemens Nixdorf
Informationssysteme AG, Munich Germany hacked slightly to upgrade Xop
for Wcl release 2.0.
