# This file was autogenerated.
use 5.008001;
use strict;
use warnings;
no warnings qw( void once );
use Hydrogen ();

package Hydrogen::ArrayRef;

our $AUTHORITY = 'cpan:TOBYINK';
our $VERSION   = '0.021000';

=head1 NAME

Hydrogen::ArrayRef - a standard library for arrayrefs

=head1 VERSION

This documentation is for Hydrogen::ArrayRef 0.021000,
which is based on Sub::HandlesVia::HandlerLibrary::Array 0.050003.

=cut

=head1 FUNCTIONS

Each function expects a reference to an array as its first argument.

=cut

use Exporter::Shiny qw(
    accessor
    all
    all_true
    any
    apply
    clear
    count
    delete
    elements
    first
    first_index
    flatten
    flatten_deep
    for_each
    for_each_pair
    get
    grep
    head
    indexed
    insert
    is_empty
    join
    map
    max
    maxstr
    min
    minstr
    natatime
    not_all_true
    pairfirst
    pairgrep
    pairkeys
    pairmap
    pairs
    pairvalues
    pick_random
    pop
    print
    product
    push
    reduce
    reductions
    reset
    reverse
    sample
    set
    shallow_clone
    shift
    shuffle
    shuffle_in_place
    sort
    sort_in_place
    splice
    sum
    tail
    uniq
    uniq_in_place
    uniqnum
    uniqnum_in_place
    uniqstr
    uniqstr_in_place
    unshift
);

=head2 C<< accessor( $arrayref, $index, $value? ) >>

Additional arguments: B<< Int >>, B<< Optional[Any] >>.

Acts like C<get> if given just an index, or C<set> if given an index and value.

=cut

{
    my $__signature;

    sub accessor {
        my $__REF__ = \$_[0];

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 2 && @_ <= 3
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "accessor", scalar(@_), "expected exactly 2 parameters" );

            # Parameter $_[0] (type: ArrayRef)
            ( ref( $_[0] ) eq 'ARRAY' )
              or Hydrogen::croak(
                "Type check failed in signature for accessor: %s should be %s",
                "\$_[0]", "ArrayRef"
              );

            # Parameter $_[1] (type: Int)
            (
                do {
                    my $tmp = $_[1];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for accessor: %s should be %s",
                "\$_[1]", "Int"
              );

            # Parameter $_[2] (type: Optional[Any])
            $#_ >= 2
              or return (@_);
            ( !!1 )
              or Hydrogen::croak(
                "Type check failed in signature for accessor: %s should be %s",
                "\$_[2]", "Optional[Any]"
              );

            (@_);
        };
        @_ = &$__signature;
        1;
        ( ( @_ - 1 ) == 1 )
          ? ($$__REF__)->[ $_[1] ]
          : ( ($$__REF__)->[ $_[1] ] = $_[2] );
    }
}

=head2 C<< all( $arrayref ) >>

All elements in the array, in list context.

=cut

sub all {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for all; usage: "
          . "Hydrogen::ArrayRef::all( \$arrayref )" );
    @{$$__REF__};
}

=head2 C<< all_true( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Like C<< List::Util::all() >>.

=cut

sub all_true {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "all_true", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for all_true: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for all_true: %s should be %s",
            "\$_[1]", "CodeRef" );

        (@_);
    };
    &List::Util::all( $_[1], @{$$__REF__} );
}

=head2 C<< any( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Like C<< List::Util::any() >>.

=cut

sub any {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "any", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for any: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for any: %s should be %s",
            "\$_[1]", "CodeRef" );

        (@_);
    };
    &List::Util::any( $_[1], @{$$__REF__} );
}

=head2 C<< apply( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Executes the coderef (which should modify C<< $_ >>) against each element of the array; returns the resulting array in list context.

=cut

sub apply {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "apply", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for apply: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for apply: %s should be %s",
            "\$_[1]", "CodeRef" );

        (@_);
    };
    my @shv_tmp = @{$$__REF__};
    &{ $_[1] } foreach @shv_tmp;
    wantarray ? @shv_tmp : $shv_tmp[-1];
}

=head2 C<< clear( $arrayref ) >>

Empties the array.

=cut

sub clear {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for clear; usage: "
          . "Hydrogen::ArrayRef::clear( \$arrayref )" );
    1;
    @{$$__REF__} = ();
}

=head2 C<< count( $arrayref ) >>

The number of elements in the referenced array.

=cut

sub count {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for count; usage: "
          . "Hydrogen::ArrayRef::count( \$arrayref )" );
    scalar( @{$$__REF__} );
}

=head2 C<< delete( $arrayref, $index ) >>

Additional arguments: B<< Int >>.

Removes the indexed element from the array and returns it. Elements after it will be "moved up".

=cut

sub delete {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "delete", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for delete: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: Int)
        (
            do {
                my $tmp = $_[1];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for delete: %s should be %s",
            "\$_[1]", "Int" );

        (@_);
    };
    1;
    splice( @{$$__REF__}, $_[1], 1 );
}

=head2 C<< elements( $arrayref ) >>

All elements in the array, in list context. (Essentially the same as C<all>.)

=cut

sub elements {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for elements; usage: "
          . "Hydrogen::ArrayRef::elements( \$arrayref )" );
    @{$$__REF__};
}

=head2 C<< first( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Like C<< List::Util::first() >>.

=cut

sub first {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "first", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for first: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for first: %s should be %s",
            "\$_[1]", "CodeRef" );

        (@_);
    };
    &List::Util::first( $_[1], @{$$__REF__} );
}

=head2 C<< first_index( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Like C<< List::MoreUtils::first_index() >>.

=cut

sub first_index {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "first_index", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for first_index: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for first_index: %s should be %s",
            "\$_[1]", "CodeRef" );

        (@_);
    };
    for my $i ( 0 .. $#{$$__REF__} ) {
        local *_ = \$$__REF__->[$i];
        return $i if $_[1]->($_);
    };
    return -1;
}

=head2 C<< flatten( $arrayref ) >>

All elements in the array, in list context. (Essentially the same as C<all>.)

=cut

sub flatten {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for flatten; usage: "
          . "Hydrogen::ArrayRef::flatten( \$arrayref )" );
    @{$$__REF__};
}

=head2 C<< flatten_deep( $arrayref, $depth? ) >>

Additional arguments: B<< Optional[Int] >>.

Flattens the arrayref into a list, including any nested arrayrefs. (Has the potential to loop infinitely.)

=cut

{
    my $__signature;

    sub flatten_deep {
        my $__REF__ = \$_[0];

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 1 && @_ <= 2
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "flatten_deep", scalar(@_), "expected exactly 1 parameters" );

            # Parameter $_[0] (type: ArrayRef)
            ( ref( $_[0] ) eq 'ARRAY' )
              or Hydrogen::croak(
"Type check failed in signature for flatten_deep: %s should be %s",
                "\$_[0]", "ArrayRef"
              );

            # Parameter $_[1] (type: Optional[Int])
            $#_ >= 1
              or return (@_);
            (
                do {
                    my $tmp = $_[1];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
"Type check failed in signature for flatten_deep: %s should be %s",
                "\$_[1]", "Optional[Int]"
              );

            (@_);
        };
        @_ = &$__signature;
        my $shv_fd;
        $shv_fd = sub {
            my $d = pop;
            --$d if defined $d;
            map ref() eq "ARRAY"
              ? ( defined $d && $d < 0 )
                  ? $_
                  : $shv_fd->( @$_, $d )
              : $_, @_;
        };
        $shv_fd->( @{$$__REF__}, $_[1] );
    }
}

=head2 C<< for_each( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Function which executes the coderef on each element of the array. The coderef will be passed two values: the element and its index.

=cut

sub for_each {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "for_each", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for for_each: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for for_each: %s should be %s",
            "\$_[1]", "CodeRef" );

        (@_);
    };
    foreach my $shv_index ( 0 .. $#{$$__REF__} ) {
        &{ $_[1] }( ($$__REF__)->[$shv_index], $shv_index );
    };
    $__REF__;
}

=head2 C<< for_each_pair( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Function which executes the coderef on each pair of elements in the array. The coderef will be passed the two elements.

=cut

sub for_each_pair {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "for_each_pair", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for for_each_pair: %s should be %s",
            "\$_[0]", "ArrayRef"
          );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for for_each_pair: %s should be %s",
            "\$_[1]", "CodeRef"
          );

        (@_);
    };
    for ( my $shv_index = 0 ; $shv_index < @{$$__REF__} ; $shv_index += 2 ) {
        &{ $_[1] }( ($$__REF__)->[$shv_index], ($$__REF__)->[ $shv_index + 1 ] );
    };
    $__REF__;
}

=head2 C<< get( $arrayref, $index ) >>

Additional arguments: B<< Int >>.

Returns a single element from the array by index.

=cut

sub get {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "get", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for get: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: Int)
        (
            do {
                my $tmp = $_[1];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for get: %s should be %s",
            "\$_[1]", "Int" );

        (@_);
    };
    ($$__REF__)->[ $_[1] ];
}

=head2 C<< grep( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Like C<grep> from L<perlfunc>.

=cut

sub grep {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "grep", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for grep: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for grep: %s should be %s",
            "\$_[1]", "CodeRef" );

        (@_);
    };
    grep( $_[1]->($_), @{$$__REF__} );
}

=head2 C<< head( $arrayref, $count ) >>

Additional arguments: B<< Int >>.

Returns the first C<< $count >> elements of the array in list context.

=cut

sub head {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "head", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for head: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: Int)
        (
            do {
                my $tmp = $_[1];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for head: %s should be %s",
            "\$_[1]", "Int" );

        (@_);
    };
    my $shv_count = $_[1];
    $shv_count = @{$$__REF__}              if $shv_count > @{$$__REF__};
    $shv_count = @{$$__REF__} + $shv_count if $shv_count < 0;
    ( @{$$__REF__} )[ 0 .. ( $shv_count - 1 ) ];
}

=head2 C<< indexed( $arrayref ) >>

Like C<indexed> from L<builtin>.

=cut

sub indexed {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for indexed; usage: "
          . "Hydrogen::ArrayRef::indexed( \$arrayref )" );
    my $shv_ix = 0;
    map +( $shv_ix++, $_ ), @{$$__REF__};
}

=head2 C<< insert( $arrayref, $index, $value ) >>

Additional arguments: B<< Int >>, B<< Any >>.

Inserts a value into the array with the given index. Elements after it will be "moved down".

=cut

sub insert {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 3
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "insert", scalar(@_), "expected exactly 3 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for insert: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: Int)
        (
            do {
                my $tmp = $_[1];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for insert: %s should be %s",
            "\$_[1]", "Int" );

        # Parameter $_[2] (type: Any)
        1;    # ... nothing to do

        (@_);
    };
    1;
    splice( @{$$__REF__}, $_[1], 0, $_[2] );
}

=head2 C<< is_empty( $arrayref ) >>

Boolean indicating if the referenced array is empty.

=cut

sub is_empty {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for is_empty; usage: "
          . "Hydrogen::ArrayRef::is_empty( \$arrayref )" );
    !scalar( @{$$__REF__} );
}

=head2 C<< join( $arrayref, $with? ) >>

Additional arguments: B<< Optional[Str] >>.

Returns a string joining all the elements in the array; if C<< $with >> is omitted, defaults to a comma.

=cut

{
    my $__signature;

    sub join {
        my $__REF__ = \$_[0];

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 1 && @_ <= 2
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "join", scalar(@_), "expected exactly 1 parameters" );

            # Parameter $_[0] (type: ArrayRef)
            ( ref( $_[0] ) eq 'ARRAY' )
              or Hydrogen::croak(
                "Type check failed in signature for join: %s should be %s",
                "\$_[0]", "ArrayRef" );

            # Parameter $_[1] (type: Optional[Str])
            $#_ >= 1
              or return (@_);
            do {

                package Hydrogen::ArrayRef::__SANDBOX__;
                defined( $_[1] ) and do {
                    ref( \$_[1] ) eq 'SCALAR'
                      or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
                }
              }
              or Hydrogen::croak(
                "Type check failed in signature for join: %s should be %s",
                "\$_[1]", "Optional[Str]" );

            (@_);
        };
        @_ = &$__signature;
        my $shv_param_with = ( @_ - 1 ) ? $_[1] : q[,];
        join( $shv_param_with, @{$$__REF__} );
    }
}

=head2 C<< map( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Like C<map> from L<perlfunc>.

=cut

sub map {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "map", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for map: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for map: %s should be %s",
            "\$_[1]", "CodeRef" );

        (@_);
    };
    map( $_[1]->($_), @{$$__REF__} );
}

=head2 C<< max( $arrayref ) >>

Like C<< List::Util::max() >>.

=cut

sub max {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for max; usage: "
          . "Hydrogen::ArrayRef::max( \$arrayref )" );
    &List::Util::max( @{$$__REF__} );
}

=head2 C<< maxstr( $arrayref ) >>

Like C<< List::Util::maxstr() >>.

=cut

sub maxstr {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for maxstr; usage: "
          . "Hydrogen::ArrayRef::maxstr( \$arrayref )" );
    &List::Util::maxstr( @{$$__REF__} );
}

=head2 C<< min( $arrayref ) >>

Like C<< List::Util::min() >>.

=cut

sub min {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for min; usage: "
          . "Hydrogen::ArrayRef::min( \$arrayref )" );
    &List::Util::min( @{$$__REF__} );
}

=head2 C<< minstr( $arrayref ) >>

Like C<< List::Util::minstr() >>.

=cut

sub minstr {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for minstr; usage: "
          . "Hydrogen::ArrayRef::minstr( \$arrayref )" );
    &List::Util::minstr( @{$$__REF__} );
}

=head2 C<< natatime( $arrayref, $n, $callback? ) >>

Additional arguments: B<< Int >>, B<< Optional[CodeRef] >>.

Given just a number, returns an iterator which reads that many elements from the array at a time. If also given a callback, calls the callback repeatedly with those values.

=cut

{
    my $__signature;

    sub natatime {
        my $__REF__ = \$_[0];

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 2 && @_ <= 3
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "natatime", scalar(@_), "expected exactly 2 parameters" );

            # Parameter $_[0] (type: ArrayRef)
            ( ref( $_[0] ) eq 'ARRAY' )
              or Hydrogen::croak(
                "Type check failed in signature for natatime: %s should be %s",
                "\$_[0]", "ArrayRef"
              );

            # Parameter $_[1] (type: Int)
            (
                do {
                    my $tmp = $_[1];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for natatime: %s should be %s",
                "\$_[1]", "Int"
              );

            # Parameter $_[2] (type: Optional[CodeRef])
            $#_ >= 2
              or return (@_);
            ( ref( $_[2] ) eq 'CODE' )
              or Hydrogen::croak(
                "Type check failed in signature for natatime: %s should be %s",
                "\$_[2]", "Optional[CodeRef]"
              );

            (@_);
        };
        @_ = &$__signature;
        my @shv_remaining = @{$$__REF__};
        my $shv_n         = $_[1];
        my $shv_iterator  = sub { CORE::splice @shv_remaining, 0, $shv_n };
        if ( $_[2] ) {
            while ( my @shv_values = $shv_iterator->() ) {
                $_[2]->(@shv_values);
            }
        }
        else { $shv_iterator }
    }
}

=head2 C<< not_all_true( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Like C<< List::Util::notall() >>.

=cut

sub not_all_true {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "not_all_true", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for not_all_true: %s should be %s",
            "\$_[0]", "ArrayRef"
          );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for not_all_true: %s should be %s",
            "\$_[1]", "CodeRef"
          );

        (@_);
    };
    &List::Util::notall( $_[1], @{$$__REF__} );
}

=head2 C<< pairfirst( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Like C<< List::Util::pairfirst() >>.

=cut

sub pairfirst {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "pairfirst", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for pairfirst: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for pairfirst: %s should be %s",
            "\$_[1]", "CodeRef" );

        (@_);
    };
    List::Util::pairfirst { $_[1]->($_) } @{$$__REF__};
}

=head2 C<< pairgrep( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Like C<< List::Util::pairgrep() >>.

=cut

sub pairgrep {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "pairgrep", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for pairgrep: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for pairgrep: %s should be %s",
            "\$_[1]", "CodeRef" );

        (@_);
    };
    List::Util::pairgrep { $_[1]->($_) } @{$$__REF__};
}

=head2 C<< pairkeys( $arrayref ) >>

Like C<< List::Util::pairkeys() >>.

=cut

sub pairkeys {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for pairkeys; usage: "
          . "Hydrogen::ArrayRef::pairkeys( \$arrayref )" );
    &List::Util::pairkeys( @{$$__REF__} );
}

=head2 C<< pairmap( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Like C<< List::Util::pairmap() >>.

=cut

sub pairmap {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "pairmap", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for pairmap: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for pairmap: %s should be %s",
            "\$_[1]", "CodeRef" );

        (@_);
    };
    List::Util::pairmap { $_[1]->($_) } @{$$__REF__};
}

=head2 C<< pairs( $arrayref ) >>

Like C<< List::Util::pairs() >>.

=cut

sub pairs {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for pairs; usage: "
          . "Hydrogen::ArrayRef::pairs( \$arrayref )" );
    &List::Util::pairs( @{$$__REF__} );
}

=head2 C<< pairvalues( $arrayref ) >>

Like C<< List::Util::pairvalues() >>.

=cut

sub pairvalues {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for pairvalues; usage: "
          . "Hydrogen::ArrayRef::pairvalues( \$arrayref )" );
    &List::Util::pairvalues( @{$$__REF__} );
}

=head2 C<< pick_random( $arrayref, $count ) >>

Additional arguments: B<< Optional[Int] >>.

If no C<< $count >> is given, returns one element of the array at random. If C<< $count >> is given, creates a new array with that many random elements from the original array (or fewer if the original array is not long enough) and returns that as an arrayref or list depending on context

=cut

{
    my $__signature;

    sub pick_random {
        my $__REF__ = \$_[0];

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 1 && @_ <= 2
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "pick_random", scalar(@_), "expected exactly 1 parameters" );

            # Parameter $_[0] (type: ArrayRef)
            ( ref( $_[0] ) eq 'ARRAY' )
              or Hydrogen::croak(
"Type check failed in signature for pick_random: %s should be %s",
                "\$_[0]", "ArrayRef"
              );

            # Parameter $_[1] (type: Optional[Int])
            $#_ >= 1
              or return (@_);
            (
                do {
                    my $tmp = $_[1];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
"Type check failed in signature for pick_random: %s should be %s",
                "\$_[1]", "Optional[Int]"
              );

            (@_);
        };
        @_ = &$__signature;
        my @shv_tmp   = List::Util::shuffle( @{$$__REF__} );
        my $shv_count = $_[1];
        $shv_count = @{$$__REF__}              if $shv_count > @{$$__REF__};
        $shv_count = @{$$__REF__} + $shv_count if $shv_count < 0;
        if    ( wantarray and ( @_ - 1 ) ) { @shv_tmp[ 0 .. $shv_count - 1 ] }
        elsif ( ( @_ - 1 ) ) { [ @shv_tmp[ 0 .. $shv_count - 1 ] ] }
        else                 { $shv_tmp[0] }
    }
}

=head2 C<< pop( $arrayref ) >>

Removes the last element from the array and returns it.

=cut

sub pop {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for pop; usage: "
          . "Hydrogen::ArrayRef::pop( \$arrayref )" );
    1;
    pop( @{$$__REF__} );
}

=head2 C<< print( $arrayref, $fh?, $with? ) >>

Additional arguments: B<< Optional[FileHandle] >>, B<< Optional[Str] >>.

Prints a string joining all the elements in the array; if C<< $fh >> is omitted, defaults to STDOUT; if C<< $with >> is omitted, defaults to a comma.

=cut

{
    my $__signature;

    sub print {
        my $__REF__ = \$_[0];

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 1 && @_ <= 3
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "print", scalar(@_), "expected exactly 1 parameters" );

            # Parameter $_[0] (type: ArrayRef)
            ( ref( $_[0] ) eq 'ARRAY' )
              or Hydrogen::croak(
                "Type check failed in signature for print: %s should be %s",
                "\$_[0]", "ArrayRef" );

            # Parameter $_[1] (type: Optional[FileHandle])
            $#_ >= 1
              or return (@_);
            (
                do {

                    package Hydrogen::ArrayRef::__SANDBOX__;
                    use Scalar::Util ();
                    ( ref( $_[1] ) && Scalar::Util::openhandle( $_[1] ) )
                      or ( Scalar::Util::blessed( $_[1] )
                        && $_[1]->isa("IO::Handle") );
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for print: %s should be %s",
                "\$_[1]", "Optional[FileHandle]" );

            # Parameter $_[2] (type: Optional[Str])
            $#_ >= 2
              or return (@_);
            do {

                package Hydrogen::ArrayRef::__SANDBOX__;
                defined( $_[2] ) and do {
                    ref( \$_[2] ) eq 'SCALAR'
                      or ref( \( my $val = $_[2] ) ) eq 'SCALAR';
                }
              }
              or Hydrogen::croak(
                "Type check failed in signature for print: %s should be %s",
                "\$_[2]", "Optional[Str]" );

            (@_);
        };
        @_ = &$__signature;
        my $shv_param_with = ( ( @_ - 1 ) > 1 ) ? $_[2] : q[,];
        print { $_[1] || *STDOUT } join( $shv_param_with, @{$$__REF__} );
    }
}

=head2 C<< product( $arrayref ) >>

Like C<< List::Util::product() >>.

=cut

sub product {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for product; usage: "
          . "Hydrogen::ArrayRef::product( \$arrayref )" );
    &List::Util::product( 1, @{$$__REF__} );
}

=head2 C<< push( $arrayref, @values ) >>

Adds elements to the end of the array.

=cut

sub push {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    1;
    push( @{$$__REF__}, @_[ 1 .. $#_ ] );
}

=head2 C<< reduce( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Like C<< List::Util::reduce() >>.

=cut

sub reduce {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "reduce", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for reduce: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for reduce: %s should be %s",
            "\$_[1]", "CodeRef" );

        (@_);
    };
    my $shv_callback = $_[1];
    List::Util::reduce { $shv_callback->( $a, $b ) } @{$$__REF__};
}

=head2 C<< reductions( $arrayref, $coderef ) >>

Additional arguments: B<< CodeRef >>.

Like C<< List::Util::reductions() >>.

=cut

sub reductions {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "reductions", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for reductions: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: CodeRef)
        ( ref( $_[1] ) eq 'CODE' )
          or Hydrogen::croak(
            "Type check failed in signature for reductions: %s should be %s",
            "\$_[1]", "CodeRef" );

        (@_);
    };
    my $shv_callback = $_[1];
    List::Util::reductions { $shv_callback->( $a, $b ) } @{$$__REF__};
}

=head2 C<< reset( $arrayref ) >>

Resets the original value to its default value, or an empty arrayref if it has no default.

=cut

sub reset {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for reset; usage: "
          . "Hydrogen::ArrayRef::reset( \$arrayref )" );
    (
        @{ $_[0] } = @{
            +do {
                my $shv_final_unchecked = [];
                do {
                    ( ref($shv_final_unchecked) eq 'ARRAY' )
                      or Hydrogen::croak(
"Type check failed for reset: expected %s, got value %s",
                        "ArrayRef", $shv_final_unchecked
                      );
                    $shv_final_unchecked;
                };
            }
        }
    );
}

=head2 C<< reverse( $arrayref ) >>

Returns the reversed array in list context.

=cut

sub reverse {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for reverse; usage: "
          . "Hydrogen::ArrayRef::reverse( \$arrayref )" );
    reverse @{$$__REF__};
}

=head2 C<< sample( $arrayref, $count ) >>

Additional arguments: B<< Int >>.

Like C<< List::Util::sample() >>.

=cut

sub sample {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "sample", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for sample: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: Int)
        (
            do {
                my $tmp = $_[1];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for sample: %s should be %s",
            "\$_[1]", "Int" );

        (@_);
    };
    &List::Util::sample( $_[1], @{$$__REF__} );
}

=head2 C<< set( $arrayref, $index, $value ) >>

Additional arguments: B<< Int >>, B<< Any >>.

Sets the element with the given index to the supplied value.

=cut

sub set {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 3
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "set", scalar(@_), "expected exactly 3 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for set: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: Int)
        (
            do {
                my $tmp = $_[1];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for set: %s should be %s",
            "\$_[1]", "Int" );

        # Parameter $_[2] (type: Any)
        1;    # ... nothing to do

        (@_);
    };
    1;
    ($$__REF__)->[ $_[1] ] = $_[2];
}

=head2 C<< shallow_clone( $arrayref ) >>

Creates a new arrayref with the same elements as the original.

=cut

sub shallow_clone {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or
      Hydrogen::croak( "Wrong number of parameters for shallow_clone; usage: "
          . "Hydrogen::ArrayRef::shallow_clone( \$arrayref )" );
    [ @{$$__REF__} ];
}

=head2 C<< shift( $arrayref ) >>

Removes an element from the start of the array and returns it.

=cut

sub shift {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for shift; usage: "
          . "Hydrogen::ArrayRef::shift( \$arrayref )" );
    1;
    shift( @{$$__REF__} );
}

=head2 C<< shuffle( $arrayref ) >>

Returns the array in a random order; can be called in list context or scalar context and will return an arrayref in the latter case.

=cut

sub shuffle {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for shuffle; usage: "
          . "Hydrogen::ArrayRef::shuffle( \$arrayref )" );
    my @shv_return = List::Util::shuffle( @{$$__REF__} );
    wantarray ? @shv_return : \@shv_return;
}

=head2 C<< shuffle_in_place( $arrayref ) >>

Rearranges the array in a random order, and changes the original value to point to the new order.

=cut

sub shuffle_in_place {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak(
            "Wrong number of parameters for shuffle_in_place; usage: "
          . "Hydrogen::ArrayRef::shuffle_in_place( \$arrayref )" );
    1;
    my @shv_return = List::Util::shuffle( @{$$__REF__} );
    ( @{ $_[0] } = @{ +\@shv_return } );
}

=head2 C<< sort( $arrayref, $coderef? ) >>

Additional arguments: B<< Optional[CodeRef] >>.

Like C<sort> from L<perlfunc>.

=cut

{
    my $__signature;

    sub sort {
        my $__REF__ = \$_[0];

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 1 && @_ <= 2
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "sort", scalar(@_), "expected exactly 1 parameters" );

            # Parameter $_[0] (type: ArrayRef)
            ( ref( $_[0] ) eq 'ARRAY' )
              or Hydrogen::croak(
                "Type check failed in signature for sort: %s should be %s",
                "\$_[0]", "ArrayRef" );

            # Parameter $_[1] (type: Optional[CodeRef])
            $#_ >= 1
              or return (@_);
            ( ref( $_[1] ) eq 'CODE' )
              or Hydrogen::croak(
                "Type check failed in signature for sort: %s should be %s",
                "\$_[1]", "Optional[CodeRef]" );

            (@_);
        };
        @_ = &$__signature;
        my @shv_return =
          $_[1]
          ? ( sort { $_[1]->( $a, $b ) } @{$$__REF__} )
          : ( sort @{$$__REF__} );
    }
}

=head2 C<< sort_in_place( $arrayref, $coderef? ) >>

Additional arguments: B<< Optional[CodeRef] >>.

Like C<sort> from L<perlfunc>, but changes the original value to point to the newly sorted array.

=cut

{
    my $__signature;

    sub sort_in_place {
        my $__REF__ = \$_[0];

        package Hydrogen::ArrayRef::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 1 && @_ <= 2
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "sort_in_place", scalar(@_), "expected exactly 1 parameters" );

            # Parameter $_[0] (type: ArrayRef)
            ( ref( $_[0] ) eq 'ARRAY' )
              or Hydrogen::croak(
"Type check failed in signature for sort_in_place: %s should be %s",
                "\$_[0]", "ArrayRef"
              );

            # Parameter $_[1] (type: Optional[CodeRef])
            $#_ >= 1
              or return (@_);
            ( ref( $_[1] ) eq 'CODE' )
              or Hydrogen::croak(
"Type check failed in signature for sort_in_place: %s should be %s",
                "\$_[1]", "Optional[CodeRef]"
              );

            (@_);
        };
        @_ = &$__signature;
        1;
        my @shv_return =
          $_[1]
          ? ( sort { $_[1]->( $a, $b ) } @{$$__REF__} )
          : ( sort @{$$__REF__} );
        ( @{ $_[0] } = @{ +\@shv_return } );
    }
}

=head2 C<< splice( $arrayref, $index, $length, @values ) >>

Like C<splice> from L<perlfunc>.

=cut

sub splice {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ >= 2
      or Hydrogen::croak( "Wrong number of parameters for splice; usage: "
          . "Hydrogen::ArrayRef::splice( \$arrayref, \$index, \$length, \@values )"
      );
    if ( ( @_ - 1 ) >= 1 ) {
        do {
            (
                do {
                    my $tmp = $_[1];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed for splice: expected %s, got value %s",
                "Int", $_[1] );
            $_[1];
        };
    }
    ;
    if ( ( @_ - 1 ) >= 2 ) {
        do {
            (
                do {
                    my $tmp = $_[2];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed for splice: expected %s, got value %s",
                "Int", $_[2] );
            $_[2];
        };
    }
    my ( $shv_index, $shv_length, @shv_values ) = @_[ 1 .. $#_ ];
    splice( @{$$__REF__}, $shv_index, $shv_length, @shv_values );
}

=head2 C<< sum( $arrayref ) >>

Like C<< List::Util::sum0() >>.

=cut

sub sum {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for sum; usage: "
          . "Hydrogen::ArrayRef::sum( \$arrayref )" );
    &List::Util::sum( 0, @{$$__REF__} );
}

=head2 C<< tail( $arrayref, $count ) >>

Additional arguments: B<< Int >>.

Returns the last C<< $count >> elements of the array in list context.

=cut

sub tail {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "tail", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: ArrayRef)
        ( ref( $_[0] ) eq 'ARRAY' )
          or Hydrogen::croak(
            "Type check failed in signature for tail: %s should be %s",
            "\$_[0]", "ArrayRef" );

        # Parameter $_[1] (type: Int)
        (
            do {
                my $tmp = $_[1];
                defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for tail: %s should be %s",
            "\$_[1]", "Int" );

        (@_);
    };
    my $shv_count = $_[1];
    $shv_count = @{$$__REF__}              if $shv_count > @{$$__REF__};
    $shv_count = @{$$__REF__} + $shv_count if $shv_count < 0;
    my $shv_start = scalar( @{$$__REF__} ) - $shv_count;
    my $shv_end   = scalar( @{$$__REF__} ) - 1;
    ( @{$$__REF__} )[ $shv_start .. $shv_end ];
}

=head2 C<< uniq( $arrayref ) >>

Returns the array filtered to remove duplicates; can be called in list context or scalar context and will return an arrayref in the latter case.

=cut

sub uniq {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for uniq; usage: "
          . "Hydrogen::ArrayRef::uniq( \$arrayref )" );
    my @shv_return = List::Util::uniq( @{$$__REF__} );
    wantarray ? @shv_return : \@shv_return;
}

=head2 C<< uniq_in_place( $arrayref ) >>

Filters the array to remove duplicates, and changes the original value to point to the filtered array.

=cut

sub uniq_in_place {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or
      Hydrogen::croak( "Wrong number of parameters for uniq_in_place; usage: "
          . "Hydrogen::ArrayRef::uniq_in_place( \$arrayref )" );
    1;
    my @shv_return = List::Util::uniq( @{$$__REF__} );
    ( @{ $_[0] } = @{ +\@shv_return } );
}

=head2 C<< uniqnum( $arrayref ) >>

Returns the array filtered to remove duplicates numerically; can be called in list context or scalar context and will return an arrayref in the latter case.

=cut

sub uniqnum {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for uniqnum; usage: "
          . "Hydrogen::ArrayRef::uniqnum( \$arrayref )" );
    my @shv_return = List::Util::uniqnum( @{$$__REF__} );
    wantarray ? @shv_return : \@shv_return;
}

=head2 C<< uniqnum_in_place( $arrayref ) >>

Filters the array to remove duplicates numerically, and changes the original value to point to the filtered array.

=cut

sub uniqnum_in_place {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak(
            "Wrong number of parameters for uniqnum_in_place; usage: "
          . "Hydrogen::ArrayRef::uniqnum_in_place( \$arrayref )" );
    1;
    my @shv_return = List::Util::uniqnum( @{$$__REF__} );
    ( @{ $_[0] } = @{ +\@shv_return } );
}

=head2 C<< uniqstr( $arrayref ) >>

Returns the array filtered to remove duplicates stringwise; can be called in list context or scalar context and will return an arrayref in the latter case.

=cut

sub uniqstr {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for uniqstr; usage: "
          . "Hydrogen::ArrayRef::uniqstr( \$arrayref )" );
    my @shv_return = List::Util::uniqstr( @{$$__REF__} );
    wantarray ? @shv_return : \@shv_return;
}

=head2 C<< uniqstr_in_place( $arrayref ) >>

Filters the array to remove duplicates stringwise, and changes the original value to point to the filtered array.

=cut

sub uniqstr_in_place {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak(
            "Wrong number of parameters for uniqstr_in_place; usage: "
          . "Hydrogen::ArrayRef::uniqstr_in_place( \$arrayref )" );
    1;
    my @shv_return = List::Util::uniqstr( @{$$__REF__} );
    ( @{ $_[0] } = @{ +\@shv_return } );
}

=head2 C<< unshift( $arrayref, @values ) >>

Adds an element to the start of the array.

=cut

sub unshift {
    my $__REF__ = \$_[0];

    package Hydrogen::ArrayRef::__SANDBOX__;
    1;
    unshift( @{$$__REF__}, @_[ 1 .. $#_ ] );
}

1;

=head1 EXPORT

No functions are exported by this module by default. To import them all (this is usually a bad idea), use:

    use Hydrogen::ArrayRef -all;

To import a particular function, use:

    use Hydrogen::ArrayRef 'all_true';

To rename functions:

    use Hydrogen::ArrayRef 'all_true' => { -as => 'myfunc' };

On Perl 5.37.2+ (or if L<Lexical::Sub> is installed) you can import lexically:

    use Hydrogen::ArrayRef -lexical, 'all_true';

See L<Exporter::Tiny::Manual::Importing> for more hints on importing.

=head1 BUGS

Please report any bugs to
L<http://github.com/tobyink/p5-hydrogen/issues>.

=head1 SEE ALSO

L<Hydrogen>,
L<Hydrogen::Array>,
L<Hydrogen::Curry::ArrayRef>,
L<Hydrogen::Topic::ArrayRef>,
L<Sub::HandlesVia::HandlerLibrary::Array>,
L<List::Util>,
L<List::MoreUtils>.

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2022-2025 by Toby Inkster.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

