package POE::Component::Bundle::WebDevelopment;

use strict;
use warnings;

our $VERSION = '1.001004'; # VERSION

1;

__END__

=for stopwords DOCTYPEs Ipsum Lorem bots html validator

=encoding utf8

=head1 NAME

POE::Component::Bundle::WebDevelopment - a collection of PoCos useful for Web Development

=head1 CONTENTS

This distribution provides the following
L<POE::Component> modules:

=over 4

=item * L<POE::Component::App::PNGCrush> - non-blocking wrapper around L<App::PNGCrush>

=item * L<POE::Component::CSS::Minifier> - non-blocking wrapper around L<CSS::Minifier> with URI fetching abilities

=item * L<POE::Component::JavaScript::Minifier> - non-blocking wrapper around L<JavaScript::Minifier> with URI fetching abilities

=item * L<POE::Component::Syntax::Highlight::CSS> - non-blocking wrapper around L<Syntax::Highlight::CSS>

=item * L<POE::Component::Syntax::Highlight::HTML> - non-blocking wrapper around L<Syntax::Highlight::HTML>

=item * L<POE::Component::WWW::Alexa::TrafficRank> - non-blocking wrapper around L<WWW::Alexa::TrafficRank>

=item * L<POE::Component::WWW::Cache::Google> - non-blocking wrapper around L<WWW::Cache::Google>

=item * L<POE::Component::WWW::DoctypeGrabber> - non-blocking wrapper around L<WWW::DoctypeGrabber>

=item * L<POE::Component::WWW::GetPageTitle> - non-blocking wrapper around L<WWW::GetPageTitle>

=item * L<POE::Component::WWW::Google::PageRank> - A non-blocking wrapper for L<WWW::Google::PageRank>

=item * L<POE::Component::WWW::HTMLTagAttributeCounter> - non-blocking wrapper around L<WWW::HTMLTagAttributeCounter>

=item * L<POE::Component::WWW::Lipsum> - non-blocking wrapper around L<WWW::Lipsum>

=item * L<POE::Component::WWW::WebDevout::BrowserSupportInfo> - non-blocking access to browser support API on L<http://webdevout.net>

=item * L<POE::Component::WebService::HtmlKitCom::FavIconFromImage> - non-blocking wrapper around L<WebService::HtmlKitCom::FavIconFromImage>

=item * L<POE::Component::WebService::Validator::CSS::W3C> - non-blocking wrapper around L<WebService::Validator::HTML::W3C>

=item * L<POE::Component::WebService::Validator::HTML::W3C> - a non-blocking POE wrapper around L<WebService::Validator::HTML::W3C>

=back

=head1 EXAMPLES

This distribution contains C<examples/> directory, with usage examples
of each component

=head1 REPOSITORY

Fork this module on GitHub:
L<https://github.com/zoffixznet/POE-Component-Bundle-WebDevelopment>

=head1 BUGS

To report bugs or request features, please use
L<https://github.com/zoffixznet/POE-Component-Bundle-WebDevelopment/issues>

If you can't access GitHub, you can email your request
to C<bug-POE-Component-Bundle-WebDevelopment at rt.cpan.org>

=head1 AUTHOR

Zoffix Znet <zoffix at cpan.org>
(L<http://zoffix.com/>, L<http://haslayout.net/>)

=head1 LICENSE

You can use and distribute this module under the same terms as Perl itself.
See the C<LICENSE> file included in this distribution for complete
details.

=cut