#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

ההכרזה לכל באי עולם בדבר זכויות האדם

אלינור רוזוולט מחזיקה בידה את הנוסח הספרדי של ההכרזה לכל באי עולם בדבר זכויות האדם
ההכרזה לכל באי עולם בדבר זכויות האדם (The Universal Declaration of Human Rights) היא מסמך היסוד של הקהילה הבינלאומית על זכויות האדם והאזרח. ההכרזה אומצה על ידי העצרת הכללית של האו"ם ביום 10 בדצמבר 1948, ומתארת את זכויות האדם היסודיות שצריכות לחול בכל מדינות האו"ם. זו ההגדרה הבינלאומית הראשונה של זכויות האדם, ומאז מצוין ה-10 בדצמבר כיום זכויות האדם ברחבי העולם. עקרונות ההכרזה הם בסיס חשוב במשפט הבינלאומי, ותשתית לחוקות של מדינות רבות. סעיפי ההכרזה אומצו על ידי ארגונים רבים לזכויות האדם ברחבי העולם, כבסיס לפעילותם, כמו אמנסטי אינטרנשיונל והאגודה לזכויות האזרח בישראל.

הטיוטה הראשונה של ההכרזה נכתבה על ידי ג'ון המפרי, משפטן קנדי שהיה מרצה באוניברסיטת מקגיל במונטריאול, ושימש בתפקיד מנהל המחלקה לזכויות אדם במזכירות האומות המאוחדות. בעיצוב הנוסח הסופי השתתפו בין השאר גם אלינור רוזוולט ורנה קסין.

ההכרזה עצמה, בהיותה החלטה של העצרת הכללית של האו"ם, היא בגדר המלצה בלבד, ואין לה תוקף משפטי. אולם למרות זאת, תוכן ההכרזה משמש בסיס לעקרונות משפטיים מחייבים במישור הבינלאומי.

בישיבת העצרת הכללית של האו"ם ב-10 בדצמבר 1948 אושרה ההכרזה על ידי 48 מדינות. 8 מדינות נמנעו, ערב הסעודית ודרום אפריקה הצביעו נגד. נציג ברית המועצות, שנמנעה בהצבעה, אמר כי למגילה יש "ערך מוסרי בלבד", והוא אינו יכול להצביע בעדה מכיוון שהיא לא מחייבת את כל המדינות להתאים את מערכות החוקים שלהן למגילת זכויות האדם, כפי שהוא הציע.‏[1]

הקונגרס היהודי העולמי היה שותף למהלכי הניסוח של החוק, ותמך בעמדה הסובייטית.‏[2] מדינת ישראל לא הייתה חברה באו"ם בזמן ההכרזה (היא התקבלה לאו"ם בהחלטה 273 ב-11 במאי 1949). ישראל איננה חתומה על ההכרזה ולא אישרה אותה. עם זאת, בית המשפט הגבוה לצדק הזכיר את המגילה ואימץ את עקרונותיה בחלק מפסקי הדין שלו.

תוכן עניינים  [הסתרה]
1 הרקע להכרזה בדבר זכויות האדם
2 מבנה ההכרזה
3 ביקורת
4 קישורים חיצוניים
5 ראו גם
6 הערות שוליים
הרקע להכרזה בדבר זכויות האדם[עריכת קוד מקור | עריכה]
הוועדה לזכויות האדם הוקמה בשנת ‎1947 במטרה לנסח הכרזה אוניברסלית בדבר זכויות האדם, שנתקבלה בעצרת האו"ם שנה לאחר מכן. שורשיה הרעיוניים של ההכרזה נובעים מאחת מתקופות השפל החמורות ביותר בהיסטוריה האנושית - מלחמת העולם השנייה והשואה. ההפרות המחרידות והנרחבות של זכויות האדם הבסיסיות בתקופה זו הכשירו את דעת הקהל בעולם לרעיון, כי שיתוף פעולה בינלאומי להגנת זכויות האדם וחירויותיו הבסיסיות הוא צורך חיוני לבניית חברה בינלאומית חדשה ובריאה.

מבנה ההכרזה[עריכת קוד מקור | עריכה]
ההכרזה כוללת את עקרונות היסוד הכלולות במגנה כרטה האנגלית, בהכרזת העצמאות של ארצות הברית ובהצהרת זכויות האדם והאזרח הצרפתית.

בהכרזה שני חלקים עיקריים:

מבוא: הרקע ההיסטורי והרעיוני להכרזה.
גוף ההכרזה: הכולל שלושים סעיפים, שמפרטים מגוון רחב של זכויות וחירויות יסודיות של הפרט.
בסעיף הראשון יש התייחסות לשני עקרונות חשובים: חירות ושוויון, כזכויות הטבעיות של כל אדם: "כל בני האדם נולדו בני חורין ושווים בערכם ובזכויותיהם. כולם חוננו בתבונה ובמצפון, לפיכך חובה עליהם לנהוג איש ברעהו ברוח של אחווה".

הסעיף השני מצהיר על הזכאות לזכויות שוות ללא הפליה: "כל אדם זכאי לזכויות ולחירויות שנקבעו בהכרזה זו ללא אפליה כלשהי מטעמי גזע, צבע, לשון, דת, דעה פוליטית או דעה בסוגיות אחרות, בגלל מוצא לאומי או חברתי, קניין, לידה או מעמד אחר".

כמו כן, מפרטת ההכרזה זכויות וחירויות נוספות, ביניהן:

זכויות אישיות (הזכות לחיים, לחופש, לביטחון ולפרטיות).
זכות להליכים הוגנים בפני המשפט (הכרה אישית בפני הדין, זכות להליכים שיפוטיים הוגנים, זכות הפרט להיחשב זכאי כל עוד לא הוכחה אשמתו כחוק).
זכויות הקשורות לחיים החברתיים, הפוליטיים והתרבותיים של הפרט (חירות המחשבה והמצפון, חופש הדת, חופש הביטוי, חופש ההתקהלות וההתאגדות, הזכות ליטול חלק בשלטון, הזכות לעבוד בשירות הציבורי והזכות לאזרחות).
זכויות כלכליות וחברתיות (הזכות לקניין פרטי, הזכות לרמת חיים הוגנת, הזכות לעבודה וכו'.)


TEXT

is(Text::Guess::Language->guess($text),'he','is he');

done_testing;
