# Generated by default/object.tt
package Paws::MediaLive::InputDeviceConfigurableSettings;
  use Moose;
  has ConfiguredInput => (is => 'ro', isa => 'Str', request_name => 'configuredInput', traits => ['NameInRequest']);
  has MaxBitrate => (is => 'ro', isa => 'Int', request_name => 'maxBitrate', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::InputDeviceConfigurableSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::InputDeviceConfigurableSettings object:

  $service_obj->Method(Att1 => { ConfiguredInput => $value, ..., MaxBitrate => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::InputDeviceConfigurableSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->ConfiguredInput

=head1 DESCRIPTION

Configurable settings for the input device.

=head1 ATTRIBUTES


=head2 ConfiguredInput => Str

The input source that you want to use. If the device has a source
connected to only one of its input ports, or if you don't care which
source the device sends, specify Auto. If the device has sources
connected to both its input ports, and you want to use a specific
source, specify the source.


=head2 MaxBitrate => Int

The maximum bitrate in bits per second. Set a value here to throttle
the bitrate of the source video.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

