/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.bitmap;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.util.CheckUtil;
import java.io.IOException;
import java.io.InputStream;

public class BitmapChecker
implements ContentChecker {
    OCFPackage ocf;
    Report report;
    String path;
    String mimeType;

    BitmapChecker(OCFPackage ocf, Report report, String path, String mimeType) {
        this.ocf = ocf;
        this.report = report;
        this.path = path;
        this.mimeType = mimeType;
    }

    private void checkHeader(byte[] header) {
        boolean passed = this.mimeType.equals("image/jpeg") ? header[0] == -1 && header[1] == -40 : (this.mimeType.equals("image/gif") ? header[0] == 71 && header[1] == 73 && header[2] == 70 && header[3] == 56 : (this.mimeType.equals("image/png") ? header[0] == -119 && header[1] == 80 && header[2] == 78 && header[3] == 71 : true));
        if (!passed) {
            this.report.error(null, 0, 0, "The file " + this.path + " does not appear to be of type " + this.mimeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runChecks() {
        if (!this.ocf.hasEntry(this.path)) {
            this.report.error(null, 0, 0, "image file " + this.path + " is missing");
        } else if (!this.ocf.canDecrypt(this.path)) {
            this.report.error(null, 0, 0, "image file " + this.path + " cannot be decrypted");
        } else {
            InputStream in = null;
            try {
                in = this.ocf.getInputStream(this.path);
                byte[] header = new byte[4];
                int rd = CheckUtil.readBytes(in, header, 0, 4);
                if (rd < 4) {
                    this.report.error(null, 0, 0, "image file " + this.path + " is too short");
                } else {
                    this.checkHeader(header);
                }
            }
            catch (IOException e) {
                this.report.error(null, 0, 0, "I/O error reading " + this.path);
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

