### This is the main class, the command line shell functionality

sub new {
  my $class = shift;

  $self = { messagesystem => AIMessageSystem->new(Printer->new, Scanner->new, Compiler->new), };

  bless $self, $class;
}

### bootstrap method of the shell on the command line
sub start {
  my $self = shift;

  $self->reinit;
}

sub runOnce {
  my $self = shift;

  $self->scan;
}

sub reinit {
  my $self = shift;

  my $mesg = ParserAIMessagePrint->new("What do you want to do ? [type in the word help for help]");
  $self->{messagesystem}->sendImmediate($mesg);
}

sub scan {
  my $self = shift;

  my $mesg = ParserAIMessageScan->new;

  my $scanline = $self->{messagesystem}->sendImmediate($mesg);
  ### puts the scannned in line into a command message ("command!")
  my $scanlinecommandmesg = ParserAIMessageShellCommand($scanline);
  
  $self->{messagesystem}->sendImmediate($scanlinecommandmesg);
}

1;
