/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.trees.AbstractTreebankLanguagePack;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.arabic.ArabicHeadFinder;
import edu.stanford.nlp.trees.international.arabic.ArabicTokenizer;
import edu.stanford.nlp.trees.international.arabic.ArabicTreeReaderFactory;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArabicTreebankLanguagePack
extends AbstractTreebankLanguagePack {
    private boolean detPlusNounIsBasicCategory;
    private static String[] pennPunctTags = new String[]{"PUNC", ","};
    private static String[] pennSFPunctTags = new String[]{"."};
    private static String[] collinsPunctTags = new String[]{"PUNC"};
    private static String[] pennPunctWords = new String[]{"''", "'", "``", "`", "-LRB-", "-RRB-", "-LCB-", "-RCB-", "-PLUS-", ".", "!", ",", "-", "--", "...", "%", "&", "\"", "\"__", "*", "+", "=", "-", "-RRB-_", "-RRB-__", "-_", "-__", "_", "..", "...", "......", "/", "\\", ":", ":_", ":__", ";", "?\"", "?\".", "?", "?.", ">"};
    private static String[] pennSFPunctWords = new String[]{".", "!", "?", "?\"", "?\".", "?", "?."};
    private static char[] annotationIntroducingChars = new char[]{'-', '=', '|', '#', '^', '~'};
    private static String[] pennStartSymbols = new String[]{"ROOT"};
    private static transient TokenizerFactory<? extends HasWord> tf;
    private static final Pattern detPlusNounPattern;
    static final String detPlusNoun = "DET+NOUN";
    private static final long serialVersionUID = 9081305982861675328L;

    public ArabicTreebankLanguagePack() {
        this(false);
    }

    public ArabicTreebankLanguagePack(boolean detPlusNounIsBasicCategory) {
        this.detPlusNounIsBasicCategory = detPlusNounIsBasicCategory;
    }

    @Override
    public String[] punctuationTags() {
        return pennPunctTags;
    }

    @Override
    public String[] punctuationWords() {
        return pennPunctWords;
    }

    @Override
    public String[] sentenceFinalPunctuationTags() {
        return pennSFPunctTags;
    }

    @Override
    public String[] sentenceFinalPunctuationWords() {
        return pennSFPunctWords;
    }

    @Override
    public String[] evalBIgnoredPunctuationTags() {
        return collinsPunctTags;
    }

    @Override
    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    @Override
    public String[] startSymbols() {
        return pennStartSymbols;
    }

    public void setTokenizerFactory(TokenizerFactory<? extends HasWord> tf) {
        ArabicTreebankLanguagePack.tf = tf;
    }

    @Override
    public TokenizerFactory<? extends HasWord> getTokenizerFactory() {
        if (tf == null) {
            tf = ArabicTokenizer.factory();
        }
        return tf;
    }

    @Override
    public String treebankFileExtension() {
        return "tree";
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        return new ArabicTreeReaderFactory();
    }

    public static void main(String[] args) {
        String[] strs;
        PennTreebankLanguagePack tlp = new PennTreebankLanguagePack();
        System.out.println("Start symbol: " + tlp.startSymbol());
        String start = tlp.startSymbol();
        System.out.println("Should be true: " + tlp.isStartSymbol(start));
        for (String str : strs = new String[]{"-", "-LLB-", "NP-2", "NP=3", "NP-LGS", "NP-TMP=3"}) {
            System.out.println("String: " + str + " basic: " + tlp.basicCategory(str) + " basicAndFunc: " + tlp.categoryAndFunction(str));
        }
    }

    @Override
    public String basicCategory(String category) {
        if (this.detPlusNounIsBasicCategory && detPlusNounPattern.matcher(category).find()) {
            return detPlusNoun;
        }
        return super.basicCategory(category);
    }

    public String toString() {
        return "ArabicTreebankLanguagePack";
    }

    @Override
    public HeadFinder headFinder() {
        return new ArabicHeadFinder(this);
    }

    static {
        detPlusNounPattern = Pattern.compile("^DET\\+NOUN");
    }
}

