use strict;

package Salvation::Service::View::Stack;

use Moose;

extends 'Salvation::Service::View::Stack::Frame::List';

foreach my $attr ( ( 'id', 'ftype', 'cap', 'fname' ) )
{
	has $attr => ( is => 'ro', isa => 'Undef' );
}

has '_frames'   => ( is         => 'rw',
                     isa        => 'ArrayRef[Salvation::Service::View::Stack::Frame]',
                     init_arg   => 'frames',
                     default    => sub{ [] },
                     predicate  => '_has_frames',
                     clearer    => '_clear_frames',
                     lazy       => 1
                   );

sub frames
{
	return shift -> data();
}

__PACKAGE__ -> meta() -> make_immutable();

no Moose;

-1;

# ABSTRACT: Result of object processing generated by view

=pod

=head1 NAME

Salvation::Service::View::Stack - Result of object processing generated by view

=head1 REQUIRES

L<Moose> 

=head1 DESCRIPTION

=head2 Subclass of

L<Salvation::Service::View::Stack::Frame::List>

=head1 METHODS

=head2 frames

 $stack -> frames();

Same as C<data>, but present for the sake of semantics.

=head2 id

Is not set, so is C<undef>.

=head2 ftype

Is not set, so is C<undef>.

=head2 cap

Is not set, so is C<undef>.

=head2 fname

Is not set, so is C<undef>.

=cut

