# Copyright 2020 cPanel, L. L. C.
# All rights reserved.
# http://cpanel.net
#
# This is free software; you can redistribute it and/or modify it under the
# same terms as Perl itself. See L<perlartistic>.

use ExtUtils::MakeMaker;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    META_MERGE => {
        'meta-spec' => { version => 2 },
        resources => {
            repository => {
                type => 'git',
#                url => 'git://github.com/FGasper/p5-Protocol-DBus.git',
#                web => 'https://github.com/FGasper/p5-Protocol-DBus',
            },
            bugtracker => {
#                web => 'https://github.com/FGasper/p5-Protocol-DBus/issues',
            },
        },
    },

    NAME         => 'cPanel::APIClient',
    AUTHOR       => 'Felipe Gasper (FELIPE)',
    VERSION_FROM => 'lib/cPanel/APIClient.pm',      # finds \$VERSION
    ABSTRACT_FROM => 'lib/cPanel/APIClient.pm',
    LICENSE      => 'perl',

    # Because of X::Tiny
    MIN_PERL_VERSION => 5.010000,

    PREREQ_PM    => {
        'parent'    => 0,
        'Call::Context' => 0,
        'X::Tiny'   => 0,
        'URI::Escape' => 0,
        'JSON' => 0,
    },

    TEST_REQUIRES => {
        'autodie'         => 0,
        'FindBin'         => 0,
        'Test::Fatal'     => 0,
        'Test::More'      => 0,
        'Test::Deep' => 0,
        'Test::FailWarnings' => 0,
        'Test::Class' => 0,
        'HTTP::Request' => 0,
        'HTTP::Response' => 0,
    },
);
