/* -*- mode: C; buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
 *    2008 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/opcode.pl from its data.
 * Any changes made here will be lost!
 */

typedef enum opcode {
	OP_NULL		 = 0,
	OP_STUB		 = 1,
	OP_SCALAR	 = 2,
	OP_PUSHMARK	 = 3,
	OP_WANTARRAY	 = 4,
	OP_CONST	 = 5,
	OP_GVSV		 = 6,
	OP_GV		 = 7,
	OP_GELEM	 = 8,
	OP_PADSV	 = 9,
	OP_PADSV_STORE	 = 10,
	OP_PADAV	 = 11,
	OP_PADHV	 = 12,
	OP_PADANY	 = 13,
	OP_RV2GV	 = 14,
	OP_RV2SV	 = 15,
	OP_AV2ARYLEN	 = 16,
	OP_RV2CV	 = 17,
	OP_ANONCODE	 = 18,
	OP_PROTOTYPE	 = 19,
	OP_REFGEN	 = 20,
	OP_SREFGEN	 = 21,
	OP_REF		 = 22,
	OP_BLESS	 = 23,
	OP_BACKTICK	 = 24,
	OP_GLOB		 = 25,
	OP_READLINE	 = 26,
	OP_RCATLINE	 = 27,
	OP_REGCMAYBE	 = 28,
	OP_REGCRESET	 = 29,
	OP_REGCOMP	 = 30,
	OP_MATCH	 = 31,
	OP_QR		 = 32,
	OP_SUBST	 = 33,
	OP_SUBSTCONT	 = 34,
	OP_TRANS	 = 35,
	OP_TRANSR	 = 36,
	OP_SASSIGN	 = 37,
	OP_AASSIGN	 = 38,
	OP_CHOP		 = 39,
	OP_SCHOP	 = 40,
	OP_CHOMP	 = 41,
	OP_SCHOMP	 = 42,
	OP_DEFINED	 = 43,
	OP_UNDEF	 = 44,
	OP_STUDY	 = 45,
	OP_POS		 = 46,
	OP_PREINC	 = 47,
	OP_I_PREINC	 = 48,
	OP_PREDEC	 = 49,
	OP_I_PREDEC	 = 50,
	OP_POSTINC	 = 51,
	OP_I_POSTINC	 = 52,
	OP_POSTDEC	 = 53,
	OP_I_POSTDEC	 = 54,
	OP_POW		 = 55,
	OP_MULTIPLY	 = 56,
	OP_I_MULTIPLY	 = 57,
	OP_DIVIDE	 = 58,
	OP_I_DIVIDE	 = 59,
	OP_MODULO	 = 60,
	OP_I_MODULO	 = 61,
	OP_REPEAT	 = 62,
	OP_ADD		 = 63,
	OP_I_ADD	 = 64,
	OP_SUBTRACT	 = 65,
	OP_I_SUBTRACT	 = 66,
	OP_CONCAT	 = 67,
	OP_MULTICONCAT	 = 68,
	OP_STRINGIFY	 = 69,
	OP_LEFT_SHIFT	 = 70,
	OP_RIGHT_SHIFT	 = 71,
	OP_LT		 = 72,
	OP_I_LT		 = 73,
	OP_GT		 = 74,
	OP_I_GT		 = 75,
	OP_LE		 = 76,
	OP_I_LE		 = 77,
	OP_GE		 = 78,
	OP_I_GE		 = 79,
	OP_EQ		 = 80,
	OP_I_EQ		 = 81,
	OP_NE		 = 82,
	OP_I_NE		 = 83,
	OP_NCMP		 = 84,
	OP_I_NCMP	 = 85,
	OP_SLT		 = 86,
	OP_SGT		 = 87,
	OP_SLE		 = 88,
	OP_SGE		 = 89,
	OP_SEQ		 = 90,
	OP_SNE		 = 91,
	OP_SCMP		 = 92,
	OP_BIT_AND	 = 93,
	OP_BIT_XOR	 = 94,
	OP_BIT_OR	 = 95,
	OP_NBIT_AND	 = 96,
	OP_NBIT_XOR	 = 97,
	OP_NBIT_OR	 = 98,
	OP_SBIT_AND	 = 99,
	OP_SBIT_XOR	 = 100,
	OP_SBIT_OR	 = 101,
	OP_NEGATE	 = 102,
	OP_I_NEGATE	 = 103,
	OP_NOT		 = 104,
	OP_COMPLEMENT	 = 105,
	OP_NCOMPLEMENT	 = 106,
	OP_SCOMPLEMENT	 = 107,
	OP_SMARTMATCH	 = 108,
	OP_ATAN2	 = 109,
	OP_SIN		 = 110,
	OP_COS		 = 111,
	OP_RAND		 = 112,
	OP_SRAND	 = 113,
	OP_EXP		 = 114,
	OP_LOG		 = 115,
	OP_SQRT		 = 116,
	OP_INT		 = 117,
	OP_HEX		 = 118,
	OP_OCT		 = 119,
	OP_ABS		 = 120,
	OP_LENGTH	 = 121,
	OP_SUBSTR	 = 122,
	OP_SUBSTR_LEFT	 = 123,
	OP_VEC		 = 124,
	OP_INDEX	 = 125,
	OP_RINDEX	 = 126,
	OP_SPRINTF	 = 127,
	OP_FORMLINE	 = 128,
	OP_ORD		 = 129,
	OP_CHR		 = 130,
	OP_CRYPT	 = 131,
	OP_UCFIRST	 = 132,
	OP_LCFIRST	 = 133,
	OP_UC		 = 134,
	OP_LC		 = 135,
	OP_QUOTEMETA	 = 136,
	OP_RV2AV	 = 137,
	OP_AELEMFAST	 = 138,
	OP_AELEMFAST_LEX = 139,
	OP_AELEMFASTLEX_STORE = 140,
	OP_AELEM	 = 141,
	OP_ASLICE	 = 142,
	OP_KVASLICE	 = 143,
	OP_AEACH	 = 144,
	OP_AVALUES	 = 145,
	OP_AKEYS	 = 146,
	OP_EACH		 = 147,
	OP_VALUES	 = 148,
	OP_KEYS		 = 149,
	OP_DELETE	 = 150,
	OP_EXISTS	 = 151,
	OP_RV2HV	 = 152,
	OP_HELEM	 = 153,
	OP_HSLICE	 = 154,
	OP_KVHSLICE	 = 155,
	OP_MULTIDEREF	 = 156,
	OP_UNPACK	 = 157,
	OP_PACK		 = 158,
	OP_SPLIT	 = 159,
	OP_JOIN		 = 160,
	OP_LIST		 = 161,
	OP_LSLICE	 = 162,
	OP_ANONLIST	 = 163,
	OP_ANONHASH	 = 164,
	OP_EMPTYAVHV	 = 165,
	OP_SPLICE	 = 166,
	OP_PUSH		 = 167,
	OP_POP		 = 168,
	OP_SHIFT	 = 169,
	OP_UNSHIFT	 = 170,
	OP_SORT		 = 171,
	OP_REVERSE	 = 172,
	OP_GREPSTART	 = 173,
	OP_GREPWHILE	 = 174,
	OP_ANYSTART	 = 175,
	OP_ALLSTART	 = 176,
	OP_ANYWHILE	 = 177,
	OP_MAPSTART	 = 178,
	OP_MAPWHILE	 = 179,
	OP_RANGE	 = 180,
	OP_FLIP		 = 181,
	OP_FLOP		 = 182,
	OP_AND		 = 183,
	OP_OR		 = 184,
	OP_XOR		 = 185,
	OP_DOR		 = 186,
	OP_COND_EXPR	 = 187,
	OP_ANDASSIGN	 = 188,
	OP_ORASSIGN	 = 189,
	OP_DORASSIGN	 = 190,
	OP_ENTERSUB	 = 191,
	OP_LEAVESUB	 = 192,
	OP_LEAVESUBLV	 = 193,
	OP_ARGCHECK	 = 194,
	OP_ARGELEM	 = 195,
	OP_ARGDEFELEM	 = 196,
	OP_CALLER	 = 197,
	OP_WARN		 = 198,
	OP_DIE		 = 199,
	OP_RESET	 = 200,
	OP_LINESEQ	 = 201,
	OP_NEXTSTATE	 = 202,
	OP_DBSTATE	 = 203,
	OP_UNSTACK	 = 204,
	OP_ENTER	 = 205,
	OP_LEAVE	 = 206,
	OP_SCOPE	 = 207,
	OP_ENTERITER	 = 208,
	OP_ITER		 = 209,
	OP_ENTERLOOP	 = 210,
	OP_LEAVELOOP	 = 211,
	OP_RETURN	 = 212,
	OP_LAST		 = 213,
	OP_NEXT		 = 214,
	OP_REDO		 = 215,
	OP_DUMP		 = 216,
	OP_GOTO		 = 217,
	OP_EXIT		 = 218,
	OP_METHOD	 = 219,
	OP_METHOD_NAMED	 = 220,
	OP_METHOD_SUPER	 = 221,
	OP_METHOD_REDIR	 = 222,
	OP_METHOD_REDIR_SUPER = 223,
	OP_ENTERGIVEN	 = 224,
	OP_LEAVEGIVEN	 = 225,
	OP_ENTERWHEN	 = 226,
	OP_LEAVEWHEN	 = 227,
	OP_BREAK	 = 228,
	OP_CONTINUE	 = 229,
	OP_OPEN		 = 230,
	OP_CLOSE	 = 231,
	OP_PIPE_OP	 = 232,
	OP_FILENO	 = 233,
	OP_UMASK	 = 234,
	OP_BINMODE	 = 235,
	OP_TIE		 = 236,
	OP_UNTIE	 = 237,
	OP_TIED		 = 238,
	OP_DBMOPEN	 = 239,
	OP_DBMCLOSE	 = 240,
	OP_SSELECT	 = 241,
	OP_SELECT	 = 242,
	OP_GETC		 = 243,
	OP_READ		 = 244,
	OP_ENTERWRITE	 = 245,
	OP_LEAVEWRITE	 = 246,
	OP_PRTF		 = 247,
	OP_PRINT	 = 248,
	OP_SAY		 = 249,
	OP_SYSOPEN	 = 250,
	OP_SYSSEEK	 = 251,
	OP_SYSREAD	 = 252,
	OP_SYSWRITE	 = 253,
	OP_EOF		 = 254,
	OP_TELL		 = 255,
	OP_SEEK		 = 256,
	OP_TRUNCATE	 = 257,
	OP_FCNTL	 = 258,
	OP_IOCTL	 = 259,
	OP_FLOCK	 = 260,
	OP_SEND		 = 261,
	OP_RECV		 = 262,
	OP_SOCKET	 = 263,
	OP_SOCKPAIR	 = 264,
	OP_BIND		 = 265,
	OP_CONNECT	 = 266,
	OP_LISTEN	 = 267,
	OP_ACCEPT	 = 268,
	OP_SHUTDOWN	 = 269,
	OP_GSOCKOPT	 = 270,
	OP_SSOCKOPT	 = 271,
	OP_GETSOCKNAME	 = 272,
	OP_GETPEERNAME	 = 273,
	OP_LSTAT	 = 274,
	OP_STAT		 = 275,
	OP_FTRREAD	 = 276,
	OP_FTRWRITE	 = 277,
	OP_FTREXEC	 = 278,
	OP_FTEREAD	 = 279,
	OP_FTEWRITE	 = 280,
	OP_FTEEXEC	 = 281,
	OP_FTIS		 = 282,
	OP_FTSIZE	 = 283,
	OP_FTMTIME	 = 284,
	OP_FTATIME	 = 285,
	OP_FTCTIME	 = 286,
	OP_FTROWNED	 = 287,
	OP_FTEOWNED	 = 288,
	OP_FTZERO	 = 289,
	OP_FTSOCK	 = 290,
	OP_FTCHR	 = 291,
	OP_FTBLK	 = 292,
	OP_FTFILE	 = 293,
	OP_FTDIR	 = 294,
	OP_FTPIPE	 = 295,
	OP_FTSUID	 = 296,
	OP_FTSGID	 = 297,
	OP_FTSVTX	 = 298,
	OP_FTLINK	 = 299,
	OP_FTTTY	 = 300,
	OP_FTTEXT	 = 301,
	OP_FTBINARY	 = 302,
	OP_CHDIR	 = 303,
	OP_CHOWN	 = 304,
	OP_CHROOT	 = 305,
	OP_UNLINK	 = 306,
	OP_CHMOD	 = 307,
	OP_UTIME	 = 308,
	OP_RENAME	 = 309,
	OP_LINK		 = 310,
	OP_SYMLINK	 = 311,
	OP_READLINK	 = 312,
	OP_MKDIR	 = 313,
	OP_RMDIR	 = 314,
	OP_OPEN_DIR	 = 315,
	OP_READDIR	 = 316,
	OP_TELLDIR	 = 317,
	OP_SEEKDIR	 = 318,
	OP_REWINDDIR	 = 319,
	OP_CLOSEDIR	 = 320,
	OP_FORK		 = 321,
	OP_WAIT		 = 322,
	OP_WAITPID	 = 323,
	OP_SYSTEM	 = 324,
	OP_EXEC		 = 325,
	OP_KILL		 = 326,
	OP_GETPPID	 = 327,
	OP_GETPGRP	 = 328,
	OP_SETPGRP	 = 329,
	OP_GETPRIORITY	 = 330,
	OP_SETPRIORITY	 = 331,
	OP_TIME		 = 332,
	OP_TMS		 = 333,
	OP_LOCALTIME	 = 334,
	OP_GMTIME	 = 335,
	OP_ALARM	 = 336,
	OP_SLEEP	 = 337,
	OP_SHMGET	 = 338,
	OP_SHMCTL	 = 339,
	OP_SHMREAD	 = 340,
	OP_SHMWRITE	 = 341,
	OP_MSGGET	 = 342,
	OP_MSGCTL	 = 343,
	OP_MSGSND	 = 344,
	OP_MSGRCV	 = 345,
	OP_SEMOP	 = 346,
	OP_SEMGET	 = 347,
	OP_SEMCTL	 = 348,
	OP_REQUIRE	 = 349,
	OP_DOFILE	 = 350,
	OP_HINTSEVAL	 = 351,
	OP_ENTEREVAL	 = 352,
	OP_LEAVEEVAL	 = 353,
	OP_ENTERTRY	 = 354,
	OP_LEAVETRY	 = 355,
	OP_GHBYNAME	 = 356,
	OP_GHBYADDR	 = 357,
	OP_GHOSTENT	 = 358,
	OP_GNBYNAME	 = 359,
	OP_GNBYADDR	 = 360,
	OP_GNETENT	 = 361,
	OP_GPBYNAME	 = 362,
	OP_GPBYNUMBER	 = 363,
	OP_GPROTOENT	 = 364,
	OP_GSBYNAME	 = 365,
	OP_GSBYPORT	 = 366,
	OP_GSERVENT	 = 367,
	OP_SHOSTENT	 = 368,
	OP_SNETENT	 = 369,
	OP_SPROTOENT	 = 370,
	OP_SSERVENT	 = 371,
	OP_EHOSTENT	 = 372,
	OP_ENETENT	 = 373,
	OP_EPROTOENT	 = 374,
	OP_ESERVENT	 = 375,
	OP_GPWNAM	 = 376,
	OP_GPWUID	 = 377,
	OP_GPWENT	 = 378,
	OP_SPWENT	 = 379,
	OP_EPWENT	 = 380,
	OP_GGRNAM	 = 381,
	OP_GGRGID	 = 382,
	OP_GGRENT	 = 383,
	OP_SGRENT	 = 384,
	OP_EGRENT	 = 385,
	OP_GETLOGIN	 = 386,
	OP_SYSCALL	 = 387,
	OP_LOCK		 = 388,
	OP_ONCE		 = 389,
	OP_CUSTOM	 = 390,
	OP_COREARGS	 = 391,
	OP_AVHVSWITCH	 = 392,
	OP_RUNCV	 = 393,
	OP_FC		 = 394,
	OP_PADCV	 = 395,
	OP_INTROCV	 = 396,
	OP_CLONECV	 = 397,
	OP_PADRANGE	 = 398,
	OP_REFASSIGN	 = 399,
	OP_LVREF	 = 400,
	OP_LVREFSLICE	 = 401,
	OP_LVAVREF	 = 402,
	OP_ANONCONST	 = 403,
	OP_ISA		 = 404,
	OP_CMPCHAIN_AND	 = 405,
	OP_CMPCHAIN_DUP	 = 406,
	OP_ENTERTRYCATCH = 407,
	OP_LEAVETRYCATCH = 408,
	OP_POPTRY	 = 409,
	OP_CATCH	 = 410,
	OP_PUSHDEFER	 = 411,
	OP_IS_BOOL	 = 412,
	OP_IS_WEAK	 = 413,
	OP_WEAKEN	 = 414,
	OP_UNWEAKEN	 = 415,
	OP_BLESSED	 = 416,
	OP_REFADDR	 = 417,
	OP_REFTYPE	 = 418,
	OP_CEIL		 = 419,
	OP_FLOOR	 = 420,
	OP_IS_TAINTED	 = 421,
	OP_HELEMEXISTSOR = 422,
	OP_METHSTART	 = 423,
	OP_INITFIELD	 = 424,
	OP_CLASSNAME	 = 425,
	OP_max		
} opcode;

/*
=for apidoc Ay||opcode
An enum of all the legal Perl opcodes, defined in F<opnames.h>

=cut
*/

#define MAXO 426
#define OP_FREED MAXO

/* the OP_IS_* macros are optimized to a simple range check because
    all the member OPs are contiguous in regen/opcodes table.
    opcode.pl verifies the range contiguity, or generates an OR-equals
    expression */

#define OP_IS_SOCKET(op)   \
	((op) >= OP_SEND && (op) <= OP_GETPEERNAME)

#define OP_IS_FILETEST(op)   \
	((op) >= OP_FTRREAD && (op) <= OP_FTBINARY)

#define OP_IS_FILETEST_ACCESS(op)   \
	((op) >= OP_FTRREAD && (op) <= OP_FTEEXEC)

#define OP_IS_NUMCOMPARE(op)   \
	((op) >= OP_LT && (op) <= OP_I_NCMP)

#define OP_IS_DIRHOP(op)   \
	((op) >= OP_READDIR && (op) <= OP_CLOSEDIR)

#define OP_IS_INFIX_BIT(op)   \
	((op) >= OP_BIT_AND && (op) <= OP_SBIT_OR)

/* ex: set ro ft=c: */
