/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.constant;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;

public abstract class MethodConstant
implements StackManipulation {
    private static final String CLASS_TYPE_INTERNAL_NAME = "java/lang/Class";
    protected final MethodDescription.InDefinedShape methodDescription;

    protected MethodConstant(MethodDescription.InDefinedShape methodDescription) {
        this.methodDescription = methodDescription;
    }

    public static CanCache forMethod(MethodDescription.InDefinedShape methodDescription) {
        if (methodDescription.isTypeInitializer()) {
            return CanCacheIllegal.INSTANCE;
        }
        if (methodDescription.isConstructor()) {
            return new ForConstructor(methodDescription);
        }
        return new ForMethod(methodDescription);
    }

    private static List<StackManipulation> typeConstantsFor(List<TypeDescription> parameterTypes) {
        ArrayList<StackManipulation> typeConstants = new ArrayList<StackManipulation>(parameterTypes.size());
        for (TypeDescription parameterType : parameterTypes) {
            typeConstants.add(ClassConstant.of(parameterType));
        }
        return typeConstants;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        return new StackManipulation.Compound(this.preparation(), ArrayFactory.forType(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Class.class)).withValues(MethodConstant.typeConstantsFor(this.methodDescription.getParameters().asTypeList().asErasures())), MethodInvocation.invoke(this.accessorMethod())).apply(methodVisitor, implementationContext);
    }

    protected abstract StackManipulation preparation();

    protected abstract MethodDescription accessorMethod();

    public StackManipulation cached() {
        return this.methodDescription.isConstructor() ? new CachedConstructor(this) : new CachedMethod(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodConstant)) {
            return false;
        }
        MethodConstant other = (MethodConstant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MethodDescription.InDefinedShape this$methodDescription = this.methodDescription;
        MethodDescription.InDefinedShape other$methodDescription = other.methodDescription;
        return !(this$methodDescription == null ? other$methodDescription != null : !this$methodDescription.equals(other$methodDescription));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodConstant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MethodDescription.InDefinedShape $methodDescription = this.methodDescription;
        result = result * 59 + ($methodDescription == null ? 43 : $methodDescription.hashCode());
        return result;
    }

    protected static class CachedConstructor
    implements StackManipulation {
        private static final TypeDescription CONSTRUCTOR_TYPE = new TypeDescription.ForLoadedType(Constructor.class);
        private final StackManipulation constructorConstant;

        protected CachedConstructor(StackManipulation constructorConstant) {
            this.constructorConstant = constructorConstant;
        }

        @Override
        public boolean isValid() {
            return this.constructorConstant.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return FieldAccess.forField(implementationContext.cache(this.constructorConstant, CONSTRUCTOR_TYPE)).read().apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CachedConstructor)) {
                return false;
            }
            CachedConstructor other = (CachedConstructor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StackManipulation this$constructorConstant = this.constructorConstant;
            StackManipulation other$constructorConstant = other.constructorConstant;
            return !(this$constructorConstant == null ? other$constructorConstant != null : !this$constructorConstant.equals(other$constructorConstant));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CachedConstructor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StackManipulation $constructorConstant = this.constructorConstant;
            result = result * 59 + ($constructorConstant == null ? 43 : $constructorConstant.hashCode());
            return result;
        }
    }

    protected static class CachedMethod
    implements StackManipulation {
        private static final TypeDescription METHOD_TYPE = new TypeDescription.ForLoadedType(Method.class);
        private final StackManipulation methodConstant;

        protected CachedMethod(StackManipulation methodConstant) {
            this.methodConstant = methodConstant;
        }

        @Override
        public boolean isValid() {
            return this.methodConstant.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return FieldAccess.forField(implementationContext.cache(this.methodConstant, METHOD_TYPE)).read().apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CachedMethod)) {
                return false;
            }
            CachedMethod other = (CachedMethod)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StackManipulation this$methodConstant = this.methodConstant;
            StackManipulation other$methodConstant = other.methodConstant;
            return !(this$methodConstant == null ? other$methodConstant != null : !this$methodConstant.equals(other$methodConstant));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CachedMethod;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StackManipulation $methodConstant = this.methodConstant;
            result = result * 59 + ($methodConstant == null ? 43 : $methodConstant.hashCode());
            return result;
        }
    }

    protected static class ForConstructor
    extends MethodConstant
    implements CanCache {
        protected ForConstructor(MethodDescription.InDefinedShape methodDescription) {
            super(methodDescription);
        }

        @Override
        protected StackManipulation preparation() {
            return ClassConstant.of(this.methodDescription.getDeclaringType());
        }

        @Override
        protected MethodDescription accessorMethod() {
            try {
                return new MethodDescription.ForLoadedMethod(Class.class.getMethod("getDeclaredConstructor", Class[].class));
            }
            catch (NoSuchMethodException exception) {
                throw new IllegalStateException("Cannot locate Class::getDeclaredConstructor", exception);
            }
        }
    }

    protected static class ForMethod
    extends MethodConstant
    implements CanCache {
        protected ForMethod(MethodDescription.InDefinedShape methodDescription) {
            super(methodDescription);
        }

        @Override
        protected StackManipulation preparation() {
            return new StackManipulation.Compound(ClassConstant.of(this.methodDescription.getDeclaringType()), new TextConstant(this.methodDescription.getInternalName()));
        }

        @Override
        protected MethodDescription accessorMethod() {
            try {
                return new MethodDescription.ForLoadedMethod(Class.class.getMethod("getDeclaredMethod", String.class, Class[].class));
            }
            catch (NoSuchMethodException exception) {
                throw new IllegalStateException("Cannot locate Class::getDeclaredMethod", exception);
            }
        }
    }

    public static interface CanCache
    extends StackManipulation {
        public StackManipulation cached();
    }

    protected static enum CanCacheIllegal implements CanCache
    {
        INSTANCE;


        @Override
        public StackManipulation cached() {
            return StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return StackManipulation.Illegal.INSTANCE.apply(methodVisitor, implementationContext);
        }
    }
}

