#!perl -T

use Test::More;
use IRC::Formatting::HTML qw/irc_to_html/;

my $bold = "\002Bold";
my $html = irc_to_html($bold);
ok($html eq '<span style="font-weight: bold">Bold</span>');

my $bolditalic = "\002\026Bolditalic\002\026";
$html = irc_to_html($bolditalic);
is ($html, '<span style="color: #fff;background-color: #000;font-weight: bold">Bolditalic</span>');

my $inverse = "\026Inverse";
$html = irc_to_html($inverse);
ok($html eq '<span style="color: #fff;background-color: #000">Inverse</span>');

my $underline = "\037Underline";
$html = irc_to_html($underline);
ok($html eq '<span style="text-decoration: underline">Underline</span>');

my $color = "\0033,4Color";
$html = irc_to_html($color);
ok($html eq '<span style="color: #080;background-color: #f00">Color</span>');

my $everything = "$bold$inverse$underline$color";
$html = irc_to_html($everything);
ok($html eq '<span style="font-weight: bold">Bold</span><span style="color: #fff;background-color: #000;font-weight: bold">Inverse</span><span style="color: #fff;text-decoration: underline;background-color: #000;font-weight: bold">Underline</span><span style="color: #f00;text-decoration: underline;background-color: #080;font-weight: bold">Color</span>');

my $everything_lines = join "\n", ($bold, $inverse, $underline, $color);
$html = irc_to_html($everything_lines);
ok($html eq join "\n",
('<span style="font-weight: bold">Bold</span>',
 '<span style="color: #fff;background-color: #000">Inverse</span>',
 '<span style="text-decoration: underline">Underline</span>',
 '<span style="color: #080;background-color: #f00">Color</span>'));

done_testing();
