
######################################################################
## $Id: Label.pm 9832 2007-08-08 18:45:24Z spadkins $
######################################################################

package App::Widget::Label;
$VERSION = (q$Revision: 9832 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App;
use App::Widget;
@ISA = ( "App::Widget" );

use strict;

=head1 NAME

App::Widget::Label - A simple label

=head1 SYNOPSIS

   $name = "label";

   # official way
   use App;
   $context = App->context();
   $w = $context->widget($name);

   # internal way
   use App::Widget::Label;
   $w = App::Widget::Label->new($name);

=cut

######################################################################
# CONSTANTS
######################################################################

######################################################################
# ATTRIBUTES
######################################################################

# INPUTS FROM THE ENVIRONMENT

=head1 DESCRIPTION

This class implements a simple label.

=cut

######################################################################
# INITIALIZATION
######################################################################

# no special initialization

######################################################################
# EVENTS
######################################################################

# no events

######################################################################
# OUTPUT METHODS
######################################################################

sub html {
    my $self = shift;
    my ($html, $text);
    if ($self->{values} || $self->{domain}) {
        my ($values, $labels) = $self->values_labels();
        my $value = $self->get_value();
        if ($value =~ /,/) {
            $text = "";
            foreach my $val (split(/,/,$value)) {
                $text .= ", " if ($text);
                if (exists $labels->{$val}) {
                    $text .= $labels->{$val};
                }
                else {
                    $text .= $val;
                }
            }
        }
        else {
            if (exists $labels->{$value}) {
                $text = $labels->{$value};
            }
            else {
                $text = "";
            }
        }
    }
    else {
        $text = $self->label();
    }
    if ($self->{event}) {

        $text = $self->{values};
        my $tag_class = $self->{tag_class};

        my (@args);
        my $args = $self->{event_args};
        if ($args) {
            if (ref($args)) {
                @args = @$args;
            }
            else {
                @args = split(/,/, $args);
            }
        }
        my $name = $self->{name};
        my $event_name = $self->{event_name} || $name;
        my $event = "$event_name.$self->{event}";
        if ($#args > -1) {
            $event .= "(" . join(",", @args) . ")";
        }
        $html = "<a class=\"$tag_class\" id=\"$name\" onclick=\"f=document.forms[0]; e=getElementById('app-event-aux'); e.value = '$event'; f.submit(); e.value = ''; return(0);\">$text</a>";
    }
    else {
        $html = $text;
    }
    return($html);
}

1;

