use strict;
use warnings;
use Test::More;
use Digest::JH qw(jh_256 jh_256_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::JH->new(256)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            jh_256_hex($data), $digest,
            "jh_256_hex: $len bits of $msg"
        );
        ok(
            jh_256($data) eq pack('H*', $digest),
            "jh_256: $len bits of $msg"
        );
    }

    my $md = Digest::JH->new(256)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|46e64619c18bb0a92a5e87185a47eef83ca747b8fcc8e1412921357e326df434
00|649d408b5abf79906a84ebd5dc8166c57113575c250501b8e98c9ef5fc586347
C0|325d6713cb3ff2329f711f0901dcdcef5fc724dbe7b7e9cdfda78968420f42be
C0|fb7ca12a587e9382fee46314f91dc677c1fd19ebdceba57dac5175066687e441
80|e461e199b9b0c846d877a274e03bb1f2e2cbfc2a5f3fe1f9aa83571b0a248e16
48|b8adefe18db5ca7a86ffeeb451f532659ec6cc49d96a61a3df800133d3029b75
50|31693190f1e2f59d3361c3dca0077b48d1b09759a5054176e6cd6ccca96bcfaa
98|f7916baaa072d0c9bac88fb40cb02fe857982a6649408d107de2fcbc7c4eb7d4
CC|7b1191f13a2667830142541bfc5918543d2a434c7692e70c3e5e9bbdddb7f581
9800|974e81da9b7582123e7c71a5f00c7593773f66b24b1a77ca71ad4561d71f96f2
9D40|a76d792ebcfd531152ab793e766bae5d22ac5dfea885a7b34e3910af8cfe70c4
AA80|f2048d0da624170aeacf6437f23c261796d194e2a8483913a0ee62c1f44db129
9830|0a098df5d4034ac07f73c9c5f64b9bbec5c9d3cbf9d0b0bb41944e23db01dd70
5030|9de52c34bff54fc592946ea6eff80a1bcd373674fbe9cccdd6f96163d0f4a85a
4D24|309f322a4a56c7dac781f657b91df65efafd3eb17702a65611c1b447ca11b14d
CBDE|814e1aad1a86dddccc999713efdd099d09c8768806a25d7c989da09e6b462ace
41FB|ef3eeeae2d2457db084f2a933647d9e77a476eb4e58569a18ad4ba55754f9034
4FF400|f240206621c584e30dbe159feced7e703439e13862be6fd81984935b7d632049
FD0440|d06896f2ab50f8d02ba66489f9bb98da0c2f121e27210a6a8b182580f97bad32
424D00|0454d544989764cd96aecb921ab740e332bd4e6410055b62294899ffb1122c63
3FDEE0|254f78839245694ab4f8222079dac16074aeb6f8223adab4eb7d88830af20933
335768|079781e2eb6307241610121827925fc4e764f712d2486ee72eb548e1628bb9bf
051E7C|bb4e2f8835febb75dc0e1cf51452ba148eafa18c706e9b07b5b2bd8964257571
717F8C|86b151e27d04e236d3e49a0372b816101411f750c8e0d447545ff37b4241a9ed
1F877C|54418f1e9b472e53e2fcc3bb10d1bd13f63b3c416589401389e51896fd6766ad
EB35CF80|79914118bb91a5f1ca45bd54c6ebecffff623cc3b4cbc5ad476dfb9cc403497f
B406C480|ec6017cdc95ae2079c92e5f45654318596632806909ef02ccd45d412e9cad236
CEE88040|130e41ec97ed132deed52eae8f49171d502582deff430df78de14f215acd8183
C584DB70|94d45b922cb159cea4687266d1043c65faafdc8cc7388441b91f6bd29792f323
53587BC8|34b77a53c2982259fda8ed7823d9179a907f6136fba857e3f728708103c6bec6
69A305B0|9a2fe7dee61fc84565f28d16eb51f5cd93811099efcdce63fd02f82dfb460d26
C9375ECE|b937de47feb68f3bee5daf35ed35d8c0d7fed47ab2107d9fd70d7eee033d00e0
C1ECFDFC|8d7e972ca6eeca9b09b829e4d627c72572b6b8555c7aa081e66167e9e4a10f11
8D73E8A280|1936c624a51ac424c6d1cc848078ca4b11569d50f311bc0a4e6a2aabcb756657
06F2522080|a673cb0820c33a6046abd0f0d8fe1546307a71c814c71204f58e92e327c981e5
3EF6C36F20|73318f17b8ebf681f12652ccbe2d171812e58430fe28a230595f3e3133f90409
0127A1D340|010e80540ffdf0eb0642f3dc88ded790a1d3894793239098a0fb1db46ca92a03
6A6AB6C210|8d94e391747a355e651784e86a322076f396ca7451062eb11ba1e5bff94b9ca3
AF3175E160|d7e1c33d11cf4006d72cbd9264a1112264ebb543dcf8394259bf1586e293f13e
B66609ED86|fa06b6747ef1a4f502aa02029c8073ff1b543900b9e9f135fa0df697ebfd0da7
21F134AC57|3a550fcd062011d809cfe08aef1735089385025fa983a4c1b1ef00a85c474641
3DC2AADFFC80|1affc98c8ca9cefba644936711d59a30072ac261fdd8f92b909379350caaa7e3
9202736D2240|9117f60902bcb042d3ae9e4c0163d3d8c9cbe1d45eba58fa549625f76c23c4a1
F219BD629820|005cd7a6a47702707f9d579cd7104c07b2eee01f5c3c2bc1cf4d5ef063673cf8
F3511EE2C4B0|be91e2255d6308cb87271ac70003f223338784645c2a00e24213394461b3b7eb
3ECAB6BF7720|6a39f533610af9b912990db9b1ea3ae988497961325868ec9f478ae9122e7a2f
CD62F688F498|894380846dad6152339301f3ae9f5c293efe3b5c7adab2715f620f34919f2e5a
C2CBAA33A9F8|aa721889b5040630960595a47bb45aab170db17c863898ddae6e97cb99455912
C6F50BB74E29|b3ef5d675a1448c355e959228a66e4a6e97bc32980615a19275c60798cf8facf
79F1B4CCC62A00|7835d201646366ead94c04d2fe310fc625b9e79d5e510ef10d12ac1f401dcfef
