#!/usr/bin/perl
#
# Build script for the App::size_dir_diff distribution.
#
# Copyright 2020 Jonas Jensen
#
# This program is free software; you may redistribute it and/or modify it
# under the same terms as Perl itself.
#
# SPDX-License-Identifier: GPL-2.0-or-later
 
use 5.020;
use autodie;
use strict;
use warnings;
 
use Module::Build;
 
# Basic package configuration.
my $build = Module::Build->new(
    module_name          => 'App::size_dir_diff',
    dist_author          => 'Jonas Jensen',
    license              => 'perl',
 
    # Add additional package metadata.
    meta_merge => {
        'meta-spec' => { version => '2' },
        resources   => {
            homepage   => 'https://bitbucket.org/Kasreyn/size_dir_diff/',
            repository => {
                url  => 'git@bitbucket.org:Kasreyn/size_dir_diff.git',
                web  => 'https://bitbucket.org/Kasreyn/size_dir_diff/src',
                type => 'git',
            },
        },
    },
 
    # Other package relationships.
    configure_requires => { 'Module::Build' => 0.28 },
    requires           => {
        'perl'     => '5.020',
    },
);
 
# Generate the build script.
$build->create_build_script();
