package App::ggdrv::start ; 
use Term::ANSIColor qw[ color :constants ] ; $Term::ANSIColor::AUTORESET = 1 ;
use warnings ; 

sub start () {

print BOLD YELLOW << "EOF" ; 
下記では、最初のセットアップ手順を示す。 もっと一般的なヘルプは コマンド $0 --help を実行せよ。
この下記を実行が出来たら コマンド $0 crecord を実行して、表示される文面に従い、ローカルにclient_idとclient_secretを設定ファイルに保管する作業をせよ。
EOF

print << 'EOF' ; 

Google社の2022〜2023年時点のサービスを下記では利用している。初めてでも手際よくやれば20分間で作業は完了するであろう。
この作業の目的は、「クライアントID」(72文字)と「クライアントシークレット」(35文字)の獲得である。
なお、権限の設定については、以下の作業において、試行錯誤が発生するかもしれない。
       
[作業手順]         
1. Google Cloud Platform の画面を開く。
  1-1. 以下は全てブラウザ(Google Chrome)を用いた操作になる。
  1-2. https://console.cloud.google.com/ を開く。

2. 適当な「プロジェクト」を開く。
  2-1. Google Cloud Platform が初めてなら、利用開始する必要があるであろう。
  2-2. 適切に使える既存プロジェクトまたは新規のプロジェクトをあらかじめ用意せよ。
  3-3. 必要なら「IAMと管理」-「リソースの管理」をクリックし、プロジェクト名を適当に付与して作成。

3. Google Drive APIを有効にする。
  3-1. ナビゲーションメニュー(左側に上下に並ぶ)から「APIとサービス」-「ライブラリ」をクリック。
  3-2. APIライブラリ画面の Google WorkspaeカテゴリからGoogle Drive APIを選択。
  3-3. Google Drive API画面の「有効にする」ボタンをクリック(約10秒かかる; 権限が無いなら新しいプログジェクトを作成して試す)。

4. 認証情報に辿り着くまで : 
  4-1. 左上のハンバーガーマーク(横線3本; 青地に白文字; Google Cloud の文字列の左隣)をクリック。
  4-2. 左側のメニュー(上下に項目が並ぶ)の中からAPIのロゴの「APIとサービス」をクリック。
  4-3. さらに「認証情報」をクリック。すると、新しい画面が現れる。

5. 認証情報を追加する準備をする。
  5-1. 画面のページ内の上部に表示されている検索バーで「Google Drive API」を検索。
  5-2. 検索結果の中から、「Google Drive API」をクリック。続けて、「このAPIを試す」(青地に白文字)をクリック。
  5-3. 左側のナビゲーションメニューから「APIとサービス」-「OAuth同意画面」をクリック。
  5-4. User Typeの2択の中から、「外部」を選択。(「内部」を選択した場合については、まだ検証していない。)
  5-5. 「アプリ情報」で、必須項目であるアプリ名などを必要なだけ(合計3個)を記入。ホームページ名などは後で加筆可能。
  5-6. 「スコープの追加または削除」で41個(10個ずつ表示)の中から、Google Driveに関係しそうなものを追加。
   - 下記↓を選択して動作することは確認した(誤記はあり得る)。もっと減らしても良いのかも知れない。
   - auth/{docs,drive{,.medatata,.readonly,.apps{,.apps{,.readonly}},activity{,.readonly},.readonly}}
  5-7. テストユーザーを追加。((このアプリのために)よく使うメールアドレスを入れると良いだろう。)   

6. 認証情報を追加する。
  6-1. 「認証情報」の画面にいるとする。
  6-2. 画面の上の方の、「+認証情報を作成」(白地に青文字) をクリック。
  6-3. 3個の中から「OAuthクライアントID」をクリック。
  6-4. 7個の中から「デスクトップアプリ」を選択。(「ウェブアプリ」ではうまくいかなかった)。
  6-5. 名前を付ける。15文字くらいの片仮名でも良い。紙にメモするなど記録をとると良いだろう。
    - 5分時間が掛かると、表示されるであろう(実際は、5秒かからなかった)。
  6-6.  「OAuthクライアントを作成しました」が表示される。
    - クライアントIDとクライアントシークレットを、これから使う(これを用いて、コマンドライン上で2個のトークンを生成)。
    - これら2個をコピーして、後でさらに続く設定に用いる。(コピペの操作で行う。このすぐ次の操作で随時参照可能。)
  6-7. 「認証情報」の画面で 「OAuth 2.0 クライアント ID」 を閲覧する。
    - 今作った「クライアント」が見えるであろう。
    - 鉛筆マークのアイコンの「OAuthクライアントを表示する」が表示される場所をクリックする。
    - 「クライアント」の名前を変更したり、必要となるIDとシークレットのコピーが可能。
EOF

1 ; 
}

